/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.execution.filters.Filter;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import icons.AngularJSIcons;
import java.io.File;
import javax.swing.Icon;
import org.angularjs.cli.AngularCLIFilter;
import org.angularjs.cli.AngularJSProjectConfigurator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AngularCLIProjectGenerator
extends NpmPackageProjectGenerator {
    public static final String PACKAGE_NAME = "@angular/cli";

    @Nls
    @NotNull
    public String getName() {
        if ("Angular CLI" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "getName"));
        }
        return "Angular CLI";
    }

    public String getDescription() {
        return "The Angular2 CLI makes it easy to create an application that already works, right out of the box. It already follows Angular best practices!";
    }

    public Icon getIcon() {
        return AngularJSIcons.Angular2;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/angularjs/cli/AngularCLIProjectGenerator", "customizeModule"));
        }
        if (entry != null) {
            AngularJSProjectConfigurator.excludeDefault(baseDir, entry);
        }
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        String[] stringArray = new String[]{"new", baseDir.getName(), "--dir=."};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "generatorArgs"));
        }
        return stringArray;
    }

    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/cli/AngularCLIProjectGenerator", "filters"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/angularjs/cli/AngularCLIProjectGenerator", "filters"));
        }
        Filter[] filterArray = new Filter[]{new AngularCLIFilter(project, baseDir.getPath())};
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "filters"));
        }
        return filterArray;
    }

    @NotNull
    protected String executable(String path) {
        String string = AngularCLIProjectGenerator.ng(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "executable"));
        }
        return string;
    }

    @NotNull
    public static String ng(String path) {
        String string = path + File.separator + "bin" + File.separator + "ng";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "ng"));
        }
        return string;
    }

    @NotNull
    protected String packageName() {
        if (PACKAGE_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "packageName"));
        }
        return PACKAGE_NAME;
    }

    @NotNull
    protected String presentablePackageName() {
        if ("Angular &CLI:" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/cli/AngularCLIProjectGenerator", "presentablePackageName"));
        }
        return "Angular &CLI:";
    }
}

