/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import java.util.Collection;
import org.angularjs.codeInsight.AngularJSProcessor;
import org.angularjs.codeInsight.AngularMessageFormatCompletion;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularFilterIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.lang.AngularJSLanguage;
import org.angularjs.lang.psi.AngularJSAsExpression;
import org.angularjs.lang.psi.AngularJSFilterExpression;
import org.jetbrains.annotations.NotNull;

public class AngularJSCompletionContributor
extends CompletionContributor {
    private static final JSLookupPriority NG_VARIABLE_PRIORITY = JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/angularjs/codeInsight/AngularJSCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/angularjs/codeInsight/AngularJSCompletionContributor", "fillCompletionVariants"));
        }
        if (!AngularJSCompletionContributor.getElementLanguage(parameters).is((Language)AngularJSLanguage.INSTANCE)) {
            return;
        }
        if (AngularMessageFormatCompletion.messageFormatCompletion(parameters, result)) {
            return;
        }
        PsiReference ref = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        if (ref instanceof JSReferenceExpressionImpl && ((JSReferenceExpressionImpl)ref).getQualifier() == null) {
            PsiElement parent = ((JSReferenceExpressionImpl)ref).getParent();
            if (AngularJSCompletionContributor.addFilterVariants(result, parameters, ref, parent)) {
                return;
            }
            if (AngularJSCompletionContributor.addControllerVariants(result, parameters, ref, parent)) {
                return;
            }
            AngularJSProcessor.process(parameters.getPosition(), (Consumer<JSPsiElementBase>)((Consumer)element -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/angularjs/codeInsight/AngularJSCompletionContributor", "lambda$fillCompletionVariants$0"));
                }
                String name = element.getName();
                if (name != null) {
                    result.consume((LookupElement)JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)element, (String)name, (JSLookupPriority)NG_VARIABLE_PRIORITY, (boolean)false, (boolean)false));
                }
            }));
        }
    }

    private static boolean addControllerVariants(CompletionResultSet result, CompletionParameters parameters, PsiReference ref, PsiElement parent) {
        if (AngularJSAsExpression.isAsControllerRef(ref, parent)) {
            AngularJSCompletionContributor.addResults(result, parameters, AngularIndexUtil.getAllKeys(AngularControllerIndex.KEY, parent.getProject()));
            return true;
        }
        return false;
    }

    private static boolean addFilterVariants(CompletionResultSet result, CompletionParameters parameters, PsiReference ref, PsiElement parent) {
        if (AngularJSFilterExpression.isFilterNameRef(ref, parent)) {
            AngularJSCompletionContributor.addResults(result, parameters, AngularIndexUtil.getAllKeys(AngularFilterIndex.KEY, parent.getProject()));
            return true;
        }
        return false;
    }

    static void addResults(CompletionResultSet result, CompletionParameters parameters, Collection<String> keys) {
        for (String controller : keys) {
            result.consume((LookupElement)JSLookupUtilImpl.createPrioritizedLookupItem(null, (String)controller, (JSLookupPriority)NG_VARIABLE_PRIORITY, (boolean)false, (boolean)false));
        }
        result.runRemainingContributors(parameters, result1 -> {
            String string = result1.getLookupElement().getLookupString();
            if (!keys.contains(string)) {
                result.passResult(result1);
            }
        });
    }

    static Language getElementLanguage(CompletionParameters parameters) {
        AccessToken l = ReadAction.start();
        try {
            Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)parameters.getPosition().getContainingFile(), (int)parameters.getOffset());
            return language;
        }
        finally {
            l.finish();
        }
    }
}

