/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.HtmlXmlExtension;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.Nullable;

public class AngularJSHtmlExtension
extends HtmlXmlExtension {
    public boolean isAvailable(PsiFile file) {
        return super.isAvailable(file) && AngularIndexUtil.hasAngularJS(file.getProject());
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (("ng-" + attrName).equals(DirectiveUtil.normalizeAttributeName(attribute.getName()))) {
                return true;
            }
            if (!("[" + attrName + "]").equals(attribute.getName())) continue;
            return true;
        }
        return super.isRequiredAttributeImplicitlyPresent(tag, attrName);
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        SchemaPrefix attribute;
        if ("ng".equals(namespacePrefix) && (attribute = AngularJSHtmlExtension.findAttributeSchema(context, namespacePrefix, 0)) != null) {
            return attribute;
        }
        if (namespacePrefix != null && (namespacePrefix.startsWith("(") || namespacePrefix.startsWith("[")) && (attribute = AngularJSHtmlExtension.findAttributeSchema(context, namespacePrefix, 1)) != null) {
            return attribute;
        }
        return super.getPrefixDeclaration(context, namespacePrefix);
    }

    @Nullable
    private static SchemaPrefix findAttributeSchema(XmlTag context, String namespacePrefix, int offset) {
        for (XmlAttribute attribute : context.getAttributes()) {
            if (!attribute.getName().startsWith(namespacePrefix)) continue;
            return new SchemaPrefix(attribute, TextRange.create((int)offset, (int)namespacePrefix.length()), namespacePrefix.substring(offset));
        }
        return null;
    }
}

