/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import java.util.Collection;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectiveUtil {
    public static String getAttributeName(String text) {
        String[] split = StringUtil.unquoteString((String)text).split("(?=[A-Z])");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtil.decapitalize((String)split[i]);
        }
        return StringUtil.join((String[])split, (String)"-");
    }

    public static String normalizeAttributeName(String name) {
        if (name == null) {
            return null;
        }
        name = name.startsWith("data-") ? name.substring(5) : StringUtil.trimStart((String)name, (String)"x-");
        name = name.replace(':', '-');
        name = name.replace('_', '-');
        name = name.endsWith("-start") ? name.substring(0, name.length() - 6) : StringUtil.trimEnd((String)name, (String)"-end");
        return name;
    }

    public static boolean isAngular2Directive(PsiElement directive) {
        return directive instanceof JSImplicitElement && (directive.getParent() instanceof JSCallExpression || directive.getParent() instanceof ES6Decorator);
    }

    public static String attributeToDirective(PsiElement directive, String name) {
        if (DirectiveUtil.isAngular2Directive(directive)) {
            return name;
        }
        String[] words = name.split("-");
        for (int i = 1; i < words.length; ++i) {
            words[i] = StringUtil.capitalize((String)words[i]);
        }
        return StringUtil.join((String[])words);
    }

    public static boolean processTagDirectives(Project project, Processor<JSImplicitElement> processor) {
        Collection<String> docDirectives = AngularIndexUtil.getAllKeys(AngularDirectivesDocIndex.KEY, project);
        for (String directiveName : docDirectives) {
            JSImplicitElement directive = DirectiveUtil.getTagDirective(project, directiveName, AngularDirectivesDocIndex.KEY);
            if (directive == null || processor.process((Object)directive)) continue;
            return false;
        }
        Collection<String> directives = AngularIndexUtil.getAllKeys(AngularDirectivesIndex.KEY, project);
        for (String directiveName : directives) {
            JSImplicitElement directive;
            if (docDirectives.contains(directiveName) || (directive = DirectiveUtil.getTagDirective(project, directiveName, AngularDirectivesIndex.KEY)) == null || processor.process((Object)directive)) continue;
            return false;
        }
        return true;
    }

    public static JSImplicitElement getTagDirective(String directiveName, Project project) {
        JSImplicitElement directive = DirectiveUtil.getTagDirective(project, directiveName, AngularDirectivesDocIndex.KEY);
        return directive == null ? DirectiveUtil.getTagDirective(project, directiveName, AngularDirectivesIndex.KEY) : directive;
    }

    private static JSImplicitElement getTagDirective(Project project, String directiveName, StubIndexKey<String, JSImplicitElementProvider> index) {
        String[] split;
        String restrict;
        String restrictions;
        JSImplicitElement directive = AngularIndexUtil.resolve(project, index, directiveName);
        String string = restrictions = directive != null ? directive.getTypeString() : null;
        if (restrictions != null && !StringUtil.isEmpty((String)(restrict = AngularIndexUtil.convertRestrictions(project, (split = restrictions.split(";", -1))[0]))) && StringUtil.containsIgnoreCase((String)restrict, (String)"E")) {
            return directive;
        }
        return null;
    }

    @Nullable
    public static JSImplicitElement getDirective(@Nullable PsiElement element) {
        if (element instanceof JSImplicitElement) {
            return DirectiveUtil.getDirective(element, ((JSImplicitElement)element).getName());
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            return DirectiveUtil.getDirective(element, StringUtil.unquoteString((String)element.getText()));
        }
        return null;
    }

    @Nullable
    private static JSImplicitElement getDirective(@NotNull PsiElement element, String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/DirectiveUtil", "getDirective"));
        }
        String directiveName = DirectiveUtil.getAttributeName(name);
        JSImplicitElement directive = AngularIndexUtil.resolve(element.getProject(), AngularDirectivesIndex.KEY, directiveName);
        if (directive != null && directive.isEquivalentTo(element)) {
            return directive;
        }
        return null;
    }
}

