/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import icons.AngularJSIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularBindingDescriptor;
import org.angularjs.codeInsight.attributes.AngularEventHandlerDescriptor;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularAttributeDescriptor
extends BasicXmlAttributeDescriptor
implements XmlAttributeDescriptorEx,
PsiPresentableMetaData {
    protected final Project myProject;
    private final String myAttributeName;
    private final StubIndexKey<String, JSImplicitElementProvider> myIndex;

    public AngularAttributeDescriptor(Project project, String attributeName, StubIndexKey<String, JSImplicitElementProvider> index) {
        this.myProject = project;
        this.myAttributeName = attributeName;
        this.myIndex = index;
    }

    public static XmlAttributeDescriptor[] getFieldBasedDescriptors(JSImplicitElement declaration, String decorator, NotNullFunction<Pair<PsiElement, String>, XmlAttributeDescriptor> factory) {
        JSClass clazz = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)declaration, JSClass.class);
        if (clazz != null) {
            String decoratedName;
            JSField[] fields = clazz.getFields();
            ArrayList<Object> result = new ArrayList<Object>(fields.length);
            for (JSField jSField : fields) {
                decoratedName = AngularAttributeDescriptor.getDecoratedName((JSAttributeListOwner)jSField, decorator);
                if (decoratedName == null) continue;
                result.add(factory.fun((Object)Pair.create((Object)jSField, (Object)decoratedName)));
            }
            for (JSField jSField : clazz.getFunctions()) {
                decoratedName = AngularAttributeDescriptor.getDecoratedName((JSAttributeListOwner)jSField, decorator);
                if (decoratedName == null) continue;
                result.add(factory.fun((Object)Pair.create((Object)jSField, (Object)decoratedName)));
            }
            return result.toArray(new XmlAttributeDescriptor[result.size()]);
        }
        return EMPTY;
    }

    private static String getDecoratedName(JSAttributeListOwner field, String name) {
        JSAttributeList list = field.getAttributeList();
        if (list != null) {
            for (PsiElement candidate : list.getChildren()) {
                Object value;
                JSExpression expression;
                PsiElement child;
                if (!(candidate instanceof ES6Decorator) || !((child = candidate.getLastChild()) instanceof JSCallExpression) || !((expression = ((JSCallExpression)child).getMethodExpression()) instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)((JSReferenceExpression)expression), (String[])new String[]{name})) continue;
                JSExpression[] arguments = ((JSCallExpression)child).getArguments();
                if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression && (value = ((JSLiteralExpression)arguments[0]).getValue()) instanceof String) {
                    return (String)value;
                }
                return field.getName();
            }
        }
        return null;
    }

    @NotNull
    public static XmlAttributeDescriptor[] getFieldBasedDescriptors(JSImplicitElement declaration) {
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])AngularBindingDescriptor.getBindingDescriptors(declaration), (Object[])AngularEventHandlerDescriptor.getEventHandlerDescriptors(declaration));
        if (xmlAttributeDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/attributes/AngularAttributeDescriptor", "getFieldBasedDescriptors"));
        }
        return xmlAttributeDescriptorArray;
    }

    public PsiElement getDeclaration() {
        String name = DirectiveUtil.normalizeAttributeName(this.getName());
        JSImplicitElement declaration = AngularIndexUtil.resolve(this.myProject, AngularDirectivesIndex.KEY, name);
        return declaration != null ? declaration : AngularIndexUtil.resolve(this.myProject, AngularDirectivesDocIndex.KEY, this.getName());
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        return this.myIndex != null;
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    public String[] getEnumeratedValues() {
        if (this.myProject == null || this.myIndex == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return ArrayUtil.toStringArray(AngularIndexUtil.getAllKeys(this.myIndex, this.myProject));
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        if (this.myIndex != null) {
            return AngularIndexUtil.resolve(xmlElement.getProject(), this.myIndex, value);
        }
        return xmlElement;
    }

    @Nullable
    public String handleTargetRename(@NotNull @NonNls String newTargetName) {
        if (newTargetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "org/angularjs/codeInsight/attributes/AngularAttributeDescriptor", "handleTargetRename"));
        }
        return newTargetName;
    }

    public String getTypeName() {
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return AngularJSIcons.Angular2;
    }
}

