/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularAttributesRegistry {
    static AngularAttributeDescriptor createDescriptor(@Nullable Project project, @NotNull String directiveName) {
        if (directiveName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directiveName", "org/angularjs/codeInsight/attributes/AngularAttributesRegistry", "createDescriptor"));
        }
        if ("ng-controller".equals(directiveName)) {
            return new AngularAttributeDescriptor(project, directiveName, AngularControllerIndex.KEY);
        }
        if ("ng-app".equals(directiveName)) {
            return new AngularAttributeDescriptor(project, directiveName, AngularModuleIndex.KEY);
        }
        return new AngularAttributeDescriptor(project, directiveName, null);
    }

    public static boolean isAngularExpressionAttribute(XmlAttribute parent) {
        String attributeName = DirectiveUtil.normalizeAttributeName(parent.getName());
        JSImplicitElement directive = AngularIndexUtil.resolve(parent.getProject(), AngularDirectivesDocIndex.KEY, attributeName);
        if (directive != null) {
            String restrict = directive.getTypeString();
            String param = restrict != null ? restrict.split(";", -1)[2] : "";
            return param.endsWith("expression") || param.startsWith("string");
        }
        return false;
    }

    public static boolean isJSONAttribute(XmlAttribute parent) {
        String value = parent.getValue();
        if (value == null || !value.startsWith("{")) {
            return false;
        }
        String attributeName = DirectiveUtil.normalizeAttributeName(parent.getName());
        JSImplicitElement directive = AngularIndexUtil.resolve(parent.getProject(), AngularDirectivesDocIndex.KEY, attributeName);
        if (directive != null) {
            String restrict = directive.getTypeString();
            String type = restrict != null ? restrict.split(";", -1)[2] : "";
            return type.contains("object literal") || type.equals("mixed");
        }
        return false;
    }

    public static boolean isEventAttribute(String name, Project project) {
        return name.startsWith("(") && name.endsWith(")") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isVariableAttribute(String name, Project project) {
        return name.startsWith("#") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isTemplateAttribute(String name, Project project) {
        return name.startsWith("*") && AngularIndexUtil.hasAngularJS2(project);
    }

    public static boolean isBindingAttribute(String name, Project project) {
        return name.startsWith("[") && name.endsWith("]") && AngularIndexUtil.hasAngularJS2(project);
    }
}

