/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThreeState;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.codeInsight.attributes.AngularBindingDescriptor;
import org.angularjs.codeInsight.attributes.AngularEventHandlerDescriptor;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.Nullable;

public class AngularJSAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag xmlTag) {
        if (xmlTag != null) {
            LinkedHashMap<String, XmlAttributeDescriptor> result = new LinkedHashMap<String, XmlAttributeDescriptor>();
            Project project = xmlTag.getProject();
            XmlElementDescriptor descriptor = xmlTag.getDescriptor();
            Collection<String> directives = AngularIndexUtil.getAllKeys(AngularDirectivesIndex.KEY, project);
            if (AngularIndexUtil.hasAngularJS2(project)) {
                if (descriptor instanceof HtmlElementDescriptorImpl) {
                    XmlAttribute[] descriptors;
                    XmlAttribute[] xmlAttributeArray = descriptors = ((HtmlElementDescriptorImpl)descriptor).getDefaultAttributeDescriptors(xmlTag);
                    int n = xmlAttributeArray.length;
                    for (int i = 0; i < n; ++i) {
                        XmlAttribute attributeDescriptor = xmlAttributeArray[i];
                        String name = attributeDescriptor.getName();
                        if (!name.startsWith("on")) continue;
                        this.addAttributes(project, result, "(" + name.substring(2) + ")");
                    }
                }
                for (XmlAttribute attribute : xmlTag.getAttributes()) {
                    JSImplicitElement declaration;
                    String name = attribute.getName();
                    if (AngularJSAttributeDescriptorsProvider.isAngular2Attribute(name, project) || !directives.contains(name) || (declaration = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, name)) == null) continue;
                    for (XmlAttributeDescriptor binding : AngularAttributeDescriptor.getFieldBasedDescriptors(declaration)) {
                        result.put(binding.getName(), binding);
                    }
                }
            }
            Collection<String> docDirectives = AngularIndexUtil.getAllKeys(AngularDirectivesDocIndex.KEY, project);
            for (String directiveName : docDirectives) {
                if (AngularJSAttributeDescriptorsProvider.isApplicable(project, directiveName, xmlTag, AngularDirectivesDocIndex.KEY) != ThreeState.YES) continue;
                this.addAttributes(project, result, directiveName);
            }
            for (String directiveName : directives) {
                if (docDirectives.contains(directiveName) || AngularJSAttributeDescriptorsProvider.isApplicable(project, directiveName, xmlTag, AngularDirectivesIndex.KEY) != ThreeState.YES) continue;
                this.addAttributes(project, result, directiveName);
            }
            return result.values().toArray(new XmlAttributeDescriptor[result.size()]);
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    protected void addAttributes(Project project, Map<String, XmlAttributeDescriptor> result, String directiveName) {
        result.put(directiveName, (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName));
        if ("ng-repeat".equals(directiveName)) {
            result.put(directiveName + "-start", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName + "-start"));
            result.put(directiveName + "-end", (XmlAttributeDescriptor)AngularAttributesRegistry.createDescriptor(project, directiveName + "-end"));
        }
    }

    private static ThreeState isApplicable(Project project, String directiveName, XmlTag tag, StubIndexKey<String, JSImplicitElementProvider> index) {
        JSImplicitElement directive = AngularIndexUtil.resolve(project, index, directiveName);
        if (directive == null) {
            return ThreeState.UNSURE;
        }
        String restrictions = directive.getTypeString();
        if (restrictions != null) {
            String[] split = restrictions.split(";", -1);
            String restrict = AngularIndexUtil.convertRestrictions(project, split[0]);
            String requiredTag = split[1];
            if (!StringUtil.isEmpty((String)restrict) && !StringUtil.containsIgnoreCase((String)restrict, (String)"A")) {
                return ThreeState.NO;
            }
            if (!AngularJSAttributeDescriptorsProvider.tagMatches(tag, requiredTag)) {
                return ThreeState.NO;
            }
        }
        return ThreeState.YES;
    }

    private static boolean tagMatches(XmlTag tag, String requiredTag) {
        if (StringUtil.isEmpty((String)requiredTag) || StringUtil.equalsIgnoreCase((CharSequence)requiredTag, (CharSequence)"ANY")) {
            return true;
        }
        for (String s : requiredTag.split(",")) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)tag.getName(), (CharSequence)s.trim())) continue;
            return true;
        }
        if ("input".equalsIgnoreCase(requiredTag)) {
            XmlTag parent = tag;
            while (parent != null) {
                if (!((parent = parent.getParent()) instanceof XmlTag) || !AngularJSAttributeDescriptorsProvider.isForm(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isForm(XmlTag parent) {
        String name = parent.getName();
        return "form".equalsIgnoreCase(name) || "ng-form".equalsIgnoreCase(name);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attrName, XmlTag xmlTag) {
        if (xmlTag != null) {
            String attributeName;
            Project project = xmlTag.getProject();
            ThreeState attributeAvailable = AngularJSAttributeDescriptorsProvider.isApplicable(project, attributeName = DirectiveUtil.normalizeAttributeName(attrName), xmlTag, AngularDirectivesDocIndex.KEY);
            if (attributeAvailable == ThreeState.UNSURE) {
                attributeAvailable = AngularJSAttributeDescriptorsProvider.isApplicable(project, attributeName, xmlTag, AngularDirectivesIndex.KEY);
            }
            if (attributeAvailable == ThreeState.YES) {
                return AngularAttributesRegistry.createDescriptor(project, attributeName);
            }
            if (!AngularIndexUtil.hasAngularJS2(project)) {
                return null;
            }
            for (XmlAttribute attribute : xmlTag.getAttributes()) {
                JSImplicitElement declaration;
                if (AngularJSAttributeDescriptorsProvider.isAngular2Attribute(attribute.getName(), project) || attribute.getName().equals(attrName) || (declaration = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, attribute.getName())) == null) continue;
                for (XmlAttributeDescriptor binding : AngularAttributeDescriptor.getFieldBasedDescriptors(declaration)) {
                    if (!binding.getName().equals(attrName)) continue;
                    return binding;
                }
            }
            if (AngularAttributesRegistry.isBindingAttribute(attrName, project)) {
                return new AngularBindingDescriptor((PsiElement)xmlTag, attrName);
            }
            if (AngularAttributesRegistry.isEventAttribute(attrName, project)) {
                return new AngularEventHandlerDescriptor((PsiElement)xmlTag, attrName);
            }
            return AngularJSAttributeDescriptorsProvider.getAngular2Descriptor(attrName, project);
        }
        return null;
    }

    @Nullable
    public static AngularAttributeDescriptor getAngular2Descriptor(String attrName, Project project) {
        if (AngularJSAttributeDescriptorsProvider.isAngular2Attribute(attrName, project)) {
            return AngularAttributesRegistry.createDescriptor(project, attrName);
        }
        return null;
    }

    protected static boolean isAngular2Attribute(String attrName, Project project) {
        return AngularAttributesRegistry.isEventAttribute(attrName, project) || AngularAttributesRegistry.isBindingAttribute(attrName, project) || AngularAttributesRegistry.isVariableAttribute(attrName, project);
    }
}

