/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import org.angularjs.codeInsight.refs.AngularJSReferenceBase;
import org.angularjs.index.AngularControllerIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSControllerReferencesProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new AngularJSControllerReference((JSLiteralExpression)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static class AngularJSControllerReference
    extends AngularJSReferenceBase<JSLiteralExpression> {
        public AngularJSControllerReference(@NotNull JSLiteralExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider$AngularJSControllerReference", "<init>"));
            }
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @NotNull
        public String getCanonicalText() {
            String text = super.getCanonicalText();
            int idx = text.indexOf(" as ");
            if (idx > 0) {
                String string = text.substring(0, idx);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider$AngularJSControllerReference", "getCanonicalText"));
                }
                return string;
            }
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider$AngularJSControllerReference", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            return AngularIndexUtil.resolve(((JSLiteralExpression)this.getElement()).getProject(), AngularControllerIndex.KEY, this.getCanonicalText());
        }

        @NotNull
        public Object[] getVariants() {
            Collection<String> controllers = AngularIndexUtil.getAllKeys(AngularControllerIndex.KEY, ((JSLiteralExpression)this.getElement()).getProject());
            Object[] result = new LookupElement[controllers.size()];
            int i = 0;
            for (String controller : controllers) {
                LookupItem item = JSLookupUtilImpl.createPrioritizedLookupItem(null, (String)controller, (JSLookupPriority)JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY, (boolean)false, (boolean)false);
                result[i] = item;
                ++i;
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSControllerReferencesProvider$AngularJSControllerReference", "getVariants"));
            }
            return result;
        }
    }
}

