/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import org.angularjs.codeInsight.refs.AngularJSReferenceBase;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularSymbolIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSDIReferencesProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSDIReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/codeInsight/refs/AngularJSDIReferencesProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new AngularJSDIReference((JSParameter)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSDIReferencesProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static class AngularJSDIReference
    extends AngularJSReferenceBase<JSParameter> {
        public AngularJSDIReference(JSParameter element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            JSImplicitElement resolve = AngularIndexUtil.resolve(((JSParameter)this.getElement()).getProject(), AngularSymbolIndex.KEY, this.getCanonicalText());
            if (resolve != null) {
                return resolve;
            }
            String name = this.getCanonicalText();
            PsiFile psiFile = ((JSParameter)this.getElement()).getContainingFile();
            WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, psiFile, this.getElement());
            processor.allowPartialResults();
            JSReferenceExpressionResolver.processAllSymbols((WalkUpResolveProcessor)processor);
            ResolveResult[] results = processor.getResults();
            return results.length == 1 ? results[0].getElement() : null;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSDIReferencesProvider$AngularJSDIReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return ((JSParameter)this.getElement()).setName(newElementName);
        }
    }
}

