/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import org.angularjs.codeInsight.refs.AngularJSReferenceBase;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularTemplateCacheIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSTemplateCacheReference
extends AngularJSReferenceBase<JSLiteralExpression> {
    public AngularJSTemplateCacheReference(@NotNull JSLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSTemplateCacheReference", "<init>"));
        }
        super(element, ElementManipulators.getValueTextRange((PsiElement)element));
    }

    @NotNull
    public Object[] getVariants() {
        Collection<String> keys = AngularIndexUtil.getAllKeys(AngularTemplateCacheIndex.TEMPLATE_CACHE_INDEX, ((JSLiteralExpression)this.getElement()).getProject());
        Object[] objectArray = ArrayUtil.toStringArray(keys);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSTemplateCacheReference", "getVariants"));
        }
        return objectArray;
    }

    @Override
    @Nullable
    public PsiElement resolveInner() {
        FileBasedIndex instance = FileBasedIndex.getInstance();
        Project project = ((JSLiteralExpression)this.getElement()).getProject();
        String id = this.getCanonicalText();
        Collection files = instance.getContainingFiles(AngularTemplateCacheIndex.TEMPLATE_CACHE_INDEX, (Object)id, GlobalSearchScope.allScope((Project)project));
        Ref result = new Ref();
        for (VirtualFile file : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            AngularTemplateCacheIndex.processTemplates(psiFile, (Processor<XmlAttribute>)((Processor)attribute -> {
                if (id.equals(attribute.getValue())) {
                    result.set((Object)attribute.getValueElement());
                }
                return result.isNull();
            }));
        }
        return (PsiElement)result.get();
    }
}

