/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.angularjs.codeInsight.refs.AngularPolyReferenceBase;
import org.angularjs.codeInsight.router.AngularRouterStateLoader;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularUiRouterStatesIndex;
import org.jetbrains.annotations.NotNull;

public class AngularJSUiRouterStatesReferencesProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSUiRouterStatesReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/codeInsight/refs/AngularJSUiRouterStatesReferencesProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new AngularJSUiRouterStateReference((XmlAttributeValue)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterStatesReferencesProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class AngularJSUiRouterStateReference
    extends AngularPolyReferenceBase<XmlAttributeValue> {
        public AngularJSUiRouterStateReference(XmlAttributeValue element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        private String getStateName() {
            String text = StringUtil.unquoteString((String)this.getCanonicalText());
            int idx = text.indexOf(40);
            if (idx >= 0) {
                return text.substring(0, idx);
            }
            return text;
        }

        @Override
        @NotNull
        protected ResolveResult[] resolveInner() {
            String id = this.getStateName();
            if (StringUtil.isEmptyOrSpaces((String)id)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterStatesReferencesProvider$AngularJSUiRouterStateReference", "resolveInner"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ArrayList<JSResolveResult> list = new ArrayList<JSResolveResult>();
            AngularIndexUtil.multiResolve(((XmlAttributeValue)this.myElement).getProject(), AngularUiRouterStatesIndex.KEY, id, (Processor<JSImplicitElement>)((Processor)element -> {
                list.add(new JSResolveResult((PsiElement)element));
                return true;
            }));
            if (list.isEmpty()) {
                List<JSObjectLiteralExpression> expressions = new AngularRouterStateLoader(((XmlAttributeValue)this.myElement).getProject()).setStateName(id).loadFreelyDefinedStates();
                for (JSObjectLiteralExpression expression : expressions) {
                    JSProperty name = expression.findProperty("name");
                    list.add(new JSResolveResult((PsiElement)(name == null ? expression : name.getValue())));
                }
            }
            ResolveResult[] resolveResultArray = list.toArray(new ResolveResult[list.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterStatesReferencesProvider$AngularJSUiRouterStateReference", "resolveInner"));
            }
            return resolveResultArray;
        }

        public boolean isSoft() {
            return true;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSUiRouterStatesReferencesProvider$AngularJSUiRouterStateReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

