/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.angularjs.codeInsight.router.AngularUiRouterDiagramBuilder;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularUiRouterGenericStatesIndex;
import org.jetbrains.annotations.NotNull;

public class AngularRouterStateLoader {
    public static final String STATE_PROVIDER = "$stateProvider";
    @NotNull
    private final Project myProject;
    private String myStateName;
    private static final Set<String> STATE_FIELDS = new HashSet<String>();
    private static final Set<String> ARRAY_ITERATE_METHODS = new HashSet<String>();

    public AngularRouterStateLoader(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/codeInsight/router/AngularRouterStateLoader", "<init>"));
        }
        this.myProject = project;
    }

    public AngularRouterStateLoader setStateName(String stateName) {
        this.myStateName = stateName;
        return this;
    }

    public List<JSObjectLiteralExpression> loadFreelyDefinedStates() {
        ArrayList<JSObjectLiteralExpression> states = new ArrayList<JSObjectLiteralExpression>();
        Collection<String> allKeys = AngularIndexUtil.getAllKeys(AngularUiRouterGenericStatesIndex.KEY, this.myProject);
        for (String key : allKeys) {
            ArrayList list = new ArrayList();
            AngularIndexUtil.multiResolve(this.myProject, AngularUiRouterGenericStatesIndex.KEY, key, (Processor<JSImplicitElement>)((Processor)list::add));
            for (JSImplicitElement element : list) {
                JSCallExpression callExpression = AngularUiRouterDiagramBuilder.findWrappingCallExpression(element);
                if (callExpression == null) continue;
                AngularRouterStateLoader.findPossibleReferences(callExpression, (Processor<JSObjectLiteralExpression>)((Processor)object -> {
                    JSProperty name = object.findProperty("name");
                    if (name != null && name.getValue() instanceof JSLiteralExpression && ((JSLiteralExpression)name.getValue()).isQuotedLiteral()) {
                        for (String field : STATE_FIELDS) {
                            if (object.findProperty(field) == null || this.myStateName != null && !this.myStateName.endsWith(StringUtil.unquoteString((String)name.getValue().getText()))) continue;
                            states.add((JSObjectLiteralExpression)object);
                            return true;
                        }
                    }
                    return false;
                }));
                if (this.myStateName == null || states.isEmpty()) continue;
                return states;
            }
        }
        return states;
    }

    private static void findPossibleReferences(@NotNull JSCallExpression callExpression, @NotNull Processor<JSObjectLiteralExpression> processor) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/angularjs/codeInsight/router/AngularRouterStateLoader", "findPossibleReferences"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/angularjs/codeInsight/router/AngularRouterStateLoader", "findPossibleReferences"));
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length == 1 && arguments[0] instanceof JSReferenceExpression) {
            AngularRouterStateLoader.processReference(processor, arguments[0], 0);
        }
    }

    private static void processReference(@NotNull Processor<JSObjectLiteralExpression> processor, JSExpression argument, int deepness) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/angularjs/codeInsight/router/AngularRouterStateLoader", "processReference"));
        }
        if (deepness > 3) {
            return;
        }
        JSReferenceExpression reference = (JSReferenceExpression)argument;
        PsiElement resolved = reference.resolve();
        if (resolved != null) {
            JSCallExpression call;
            JSExpression methodExpression;
            JSFunction function;
            JSExpression initializer;
            if (resolved instanceof JSVariable && ((JSVariable)resolved).getInitializer() != null && (initializer = ((JSVariable)resolved).getInitializer()) instanceof JSObjectLiteralExpression && processor.process((Object)((JSObjectLiteralExpression)initializer))) {
                return;
            }
            Collection references = JSDefaultRenameProcessor.findReferencesForScope((PsiElement)resolved, (boolean)false, (SearchScope)resolved.getUseScope());
            for (PsiReference psiReference : references) {
                JSExpression initializer2;
                JSAssignmentExpression assignment;
                JSElement element;
                if (!(psiReference instanceof JSElement) || !((element = (JSElement)psiReference).getParent() instanceof JSDefinitionExpression) || ((JSDefinitionExpression)element.getParent()).getExpression() != element || !(element.getParent().getParent() instanceof JSAssignmentExpression) || (assignment = (JSAssignmentExpression)element.getParent().getParent()).getDefinitionExpression() == null || !((initializer2 = assignment.getDefinitionExpression().getInitializer()) instanceof JSObjectLiteralExpression)) continue;
                processor.process((Object)((JSObjectLiteralExpression)initializer2));
            }
            if (resolved.getParent() instanceof JSParameterList && resolved.getParent().getParent() instanceof JSFunction && (function = (JSFunction)resolved.getParent().getParent()).getParent() instanceof JSArgumentList && function.getParent().getParent() instanceof JSCallExpression && (methodExpression = (call = (JSCallExpression)function.getParent().getParent()).getMethodExpression()) instanceof JSReferenceExpression && ARRAY_ITERATE_METHODS.contains(((JSReferenceExpression)methodExpression).getReferenceName())) {
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (qualifier instanceof JSArrayLiteralExpression) {
                    AngularRouterStateLoader.processArrayWithIterateCallback(processor, deepness, (JSArrayLiteralExpression)qualifier);
                } else if (qualifier instanceof JSReferenceExpression) {
                    PsiElement resolve = ((JSReferenceExpression)qualifier).resolve();
                    if (resolve != null && resolve.isValid() && resolve instanceof JSVariable) {
                        if (((JSVariable)resolve).getInitializer() instanceof JSArrayLiteralExpression) {
                            AngularRouterStateLoader.processArrayWithIterateCallback(processor, deepness, (JSArrayLiteralExpression)((JSVariable)resolve).getInitializer());
                        }
                    } else {
                        AngularRouterStateLoader.processReference(processor, qualifier, deepness + 1);
                    }
                }
            }
        }
    }

    private static void processArrayWithIterateCallback(@NotNull Processor<JSObjectLiteralExpression> processor, int deepness, JSArrayLiteralExpression qualifier) {
        JSExpression[] expressions;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/angularjs/codeInsight/router/AngularRouterStateLoader", "processArrayWithIterateCallback"));
        }
        for (JSExpression expression : expressions = qualifier.getExpressions()) {
            if (expression instanceof JSObjectLiteralExpression) {
                processor.process((Object)((JSObjectLiteralExpression)expression));
                continue;
            }
            if (!(expression instanceof JSReferenceExpression)) continue;
            AngularRouterStateLoader.processReference(processor, expression, deepness + 1);
        }
    }

    static {
        STATE_FIELDS.addAll(Arrays.asList("template", "templateUrl", "templateProvider", "views", "url", "controller", "controllerAs"));
        ARRAY_ITERATE_METHODS.addAll(Arrays.asList("forEach", "map", "reduce", "reduceRight", "every", "filter", "some"));
    }
}

