/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.BaseDiagramProvider;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.modules.diagramm.JSModulesDiagramUtils;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.geom.YPoint;
import com.intellij.openapi.graph.layout.CanonicMultiStageLayouter;
import com.intellij.openapi.graph.layout.EdgeLabelModel;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.ParallelEdgeLayouter;
import com.intellij.openapi.graph.layout.organic.SmartOrganicLayouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.QuadCurveEdgeRealizer;
import com.intellij.openapi.graph.view.SmartEdgeLabelModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.StrokeBorder;
import org.angularjs.codeInsight.router.AngularEdgeLayouter;
import org.angularjs.codeInsight.router.AngularUiRouterDiagramModel;
import org.angularjs.codeInsight.router.AngularUiRouterEdge;
import org.angularjs.codeInsight.router.AngularUiRouterGraphBuilder;
import org.angularjs.codeInsight.router.AngularUiRouterNode;
import org.angularjs.codeInsight.router.AngularUiRouterProviderContext;
import org.angularjs.codeInsight.router.DiagramObject;
import org.angularjs.codeInsight.router.Type;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularUiRouterDiagramProvider
extends BaseDiagramProvider<DiagramObject> {
    public static final String ANGULAR_UI_ROUTER = "Angular-ui-router";
    public static final JBColor VIEW_COLOR = new JBColor(new Color(14811132), new Color(5807606));
    public static final BasicStroke DOTTED_STROKE = new BasicStroke(0.7f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final StrokeBorder WARNING_BORDER = new StrokeBorder(DOTTED_STROKE, (Paint)JBColor.red);
    public static final Border ERROR_BORDER = JBUI.Borders.customLine((Color)JBColor.red);
    public static final Border NORMAL_BORDER = JBUI.Borders.customLine((Color)Gray._190);
    private DiagramVfsResolver<DiagramObject> myResolver = new DiagramVfsResolver<DiagramObject>(){

        public String getQualifiedName(DiagramObject element) {
            if ((Type.template.equals((Object)element.getType()) || Type.topLevelTemplate.equals((Object)element.getType())) && element.getNavigationTarget() != null) {
                PsiFile psiFile = element.getNavigationTarget().getContainingFile();
                return psiFile == null ? "" : psiFile.getVirtualFile().getPath();
            }
            return "";
        }

        @Nullable
        public DiagramObject resolveElementByFQN(String fqn, Project project) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fqn);
            if (file == null) {
                return null;
            }
            AngularUiRouterGraphBuilder.GraphNodesBuilder builder = AngularUiRouterProviderContext.getInstance(project).getBuilder(file);
            return builder == null ? null : builder.getRootNode().getIdentifyingElement();
        }
    };
    private AbstractDiagramElementManager<DiagramObject> myElementManager = new AbstractDiagramElementManager<DiagramObject>(){

        public Object[] getNodeItems(DiagramObject parent) {
            return ArrayUtil.toObjectArray(parent.getChildrenList());
        }

        @Nullable
        public DiagramObject findInDataContext(DataContext context) {
            return null;
        }

        public boolean isAcceptableAsNode(Object element) {
            return element instanceof DiagramObject;
        }

        @Nullable
        public String getElementTitle(DiagramObject element) {
            return element.getName();
        }

        @Nullable
        public SimpleColoredText getItemName(Object element, DiagramState presentation) {
            if (element instanceof DiagramObject) {
                return new SimpleColoredText(((DiagramObject)element).getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            return null;
        }

        public String getNodeTooltip(DiagramObject element) {
            List<String> errors = element.getErrors();
            List<String> warnings = element.getWarnings();
            List<String> notes = element.getNotes();
            if (errors.isEmpty() && warnings.isEmpty() && notes.isEmpty()) {
                return element.getTooltip();
            }
            StringBuilder sb = new StringBuilder(element.getTooltip());
            if (!notes.isEmpty()) {
                for (String note : notes) {
                    sb.append('\n').append(note);
                }
            }
            sb.append("<font style=\"color:#ff0000;\">");
            if (!errors.isEmpty()) {
                sb.append('\n').append(StringUtil.pluralize((String)"Error", (int)errors.size())).append(":\n");
                for (String error : errors) {
                    sb.append(error).append('\n');
                }
            }
            if (!warnings.isEmpty()) {
                sb.append('\n').append(StringUtil.pluralize((String)"Warning", (int)warnings.size())).append(":\n");
                for (String warning : warnings) {
                    sb.append(warning).append('\n');
                }
            }
            sb.append("</font>");
            return sb.toString();
        }

        public Icon getItemIcon(Object element, DiagramState presentation) {
            return null;
        }
    };
    private DiagramColorManagerBase myColorManager = new DiagramColorManagerBase(){

        public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
            return this.getColor(node.getIdentifyingElement());
        }

        public Color getNodeBackground(Project project, Object nodeElement, boolean selected) {
            return this.getColor(nodeElement);
        }

        @Nullable
        private Color getColor(Object nodeElement) {
            if (nodeElement instanceof DiagramObject) {
                DiagramObject element = (DiagramObject)nodeElement;
                if (Type.state.equals((Object)element.getType())) {
                    return LightColors.YELLOW;
                }
                if (Type.view.equals((Object)element.getType())) {
                    return VIEW_COLOR;
                }
                if (Type.template.equals((Object)element.getType())) {
                    return LightColors.GREEN;
                }
                if (Type.templatePlaceholder.equals((Object)element.getType())) {
                    return LightColors.SLIGHTLY_GREEN;
                }
            }
            return null;
        }

        public boolean drawGradientInHeader() {
            return false;
        }
    };

    public DiagramColorManager getColorManager() {
        return this.myColorManager;
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ANGULAR_UI_ROUTER;
    }

    public DiagramElementManager<DiagramObject> getElementManager() {
        return this.myElementManager;
    }

    public DiagramVfsResolver<DiagramObject> getVfsResolver() {
        return this.myResolver;
    }

    public String getPresentableName() {
        return "AngularJS ui-router states and views";
    }

    public DiagramDataModel<DiagramObject> createDataModel(@NotNull Project project, @Nullable DiagramObject element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/codeInsight/router/AngularUiRouterDiagramProvider", "createDataModel"));
        }
        if (element == null || element.getNavigationTarget() == null) {
            return null;
        }
        VirtualFile virtualFile = element.getNavigationTarget().getContainingFile().getVirtualFile();
        AngularUiRouterGraphBuilder.GraphNodesBuilder nodesBuilder = AngularUiRouterProviderContext.getInstance(project).getBuilder(virtualFile);
        if (nodesBuilder == null) {
            return new AngularUiRouterDiagramModel(project, virtualFile, this, Collections.emptyList(), Collections.emptyList());
        }
        return new AngularUiRouterDiagramModel(project, virtualFile, this, nodesBuilder.getAllNodes(), nodesBuilder.getEdges());
    }

    @Nullable
    public DiagramPresentationModel createPresentationModel(final Project project, final Graph2D graph) {
        return new DiagramPresentationModelImpl(graph, project, (DiagramProvider)this){
            private final Map<DiagramEdge, EdgeRealizer> myEdgeRealizers;
            private Map<Integer, Integer> myEdgesPositions;
            private final Set<AngularUiRouterEdge> myVisibleEdges;
            private boolean inUpdate;
            {
                super(x0, x1, x2);
                this.myEdgeRealizers = new HashMap<DiagramEdge, EdgeRealizer>();
                this.myEdgesPositions = new HashMap<Integer, Integer>();
                this.myVisibleEdges = new HashSet<AngularUiRouterEdge>();
                this.inUpdate = false;
            }

            public boolean allowChangeVisibleCategories() {
                return false;
            }

            @NotNull
            public EdgeRealizer getEdgeRealizer(DiagramEdge edge) {
                if (!(edge instanceof AngularUiRouterEdge)) {
                    EdgeRealizer edgeRealizer = super.getEdgeRealizer(edge);
                    if (edgeRealizer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/AngularUiRouterDiagramProvider$4", "getEdgeRealizer"));
                    }
                    return edgeRealizer;
                }
                if (this.myEdgeRealizers.containsKey(edge)) {
                    EdgeRealizer edgeRealizer = this.myEdgeRealizers.get(edge);
                    if (edgeRealizer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/AngularUiRouterDiagramProvider$4", "getEdgeRealizer"));
                    }
                    return edgeRealizer;
                }
                UmlGraphBuilder builder = (UmlGraphBuilder)graph.getDataProvider((Object)"GRAPH_BUILDER").get(null);
                Edge graphEdge = builder.getEdge((Object)edge);
                AngularEdgeLayouter.OneEdgeLayouter layouter = new AngularEdgeLayouter.OneEdgeLayouter(graphEdge, (AngularUiRouterEdge)edge, graph);
                layouter.calculateEdgeLayout();
                QuadCurveEdgeRealizer realizer = layouter.getRealizer();
                for (int i = 0; i < realizer.labelCount(); ++i) {
                    realizer.removeLabel(realizer.getLabel(i));
                }
                this.myEdgeRealizers.put(edge, (EdgeRealizer)realizer);
                QuadCurveEdgeRealizer quadCurveEdgeRealizer = realizer;
                if (quadCurveEdgeRealizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/AngularUiRouterDiagramProvider$4", "getEdgeRealizer"));
                }
                return quadCurveEdgeRealizer;
            }

            public EdgeLabel[] getEdgeLabels(DiagramEdge umlEdge, String label) {
                if (!(umlEdge instanceof AngularUiRouterEdge)) {
                    return super.getEdgeLabels(umlEdge, label);
                }
                AngularUiRouterEdge angularEdge = (AngularUiRouterEdge)umlEdge;
                if (!this.isShowEdgeLabels() || umlEdge == null || StringUtil.isEmptyOrSpaces((String)angularEdge.getLabel())) {
                    return EMPTY_LABELS;
                }
                UmlGraphBuilder builder = (UmlGraphBuilder)graph.getDataProvider((Object)"GRAPH_BUILDER").get(null);
                Edge edge = builder.getEdge((Object)umlEdge);
                EdgeRealizer edgeRealizer = this.getEdgeRealizer(umlEdge);
                for (int i = 0; i < edgeRealizer.labelCount(); ++i) {
                    edgeRealizer.removeLabel(edgeRealizer.getLabel(i));
                }
                Integer position = this.calculatePosition(edge, builder);
                EdgeLabel edgeLabel = GraphManager.getGraphManager().createEdgeLabel();
                SmartEdgeLabelModel model = GraphManager.getGraphManager().createSmartEdgeLabelModel();
                edgeLabel.setLabelModel((EdgeLabelModel)model, model.createDiscreteModelParameter(position.intValue()));
                edgeLabel.setFontSize(9);
                edgeLabel.setDistance(5.0);
                edgeLabel.setTextColor(JBColor.foreground());
                this.myEdgesPositions.put(edge.index(), 1);
                return new EdgeLabel[]{edgeLabel};
            }

            private Integer calculatePosition(Edge edge, UmlGraphBuilder builder) {
                int[] nArray;
                Integer existing = this.myEdgesPositions.get(edge.index());
                if (existing != null) {
                    return existing;
                }
                ArrayList<Edge> list = new ArrayList<Edge>();
                for (Edge current : edge.getGraph().getEdgeArray()) {
                    if ((current.source().index() != edge.source().index() || current.target().index() != edge.target().index()) && (current.target().index() != edge.source().index() || current.source().index() != edge.target().index())) continue;
                    list.add(current);
                }
                boolean sourceHeavier = edge.source().degree() > edge.target().degree();
                Collections.sort(list, (o1, o2) -> {
                    YPoint s1 = ((Graph2D)o1.getGraph()).getSourcePointAbs(o1);
                    YPoint s2 = ((Graph2D)o1.getGraph()).getSourcePointAbs(o2);
                    if (Math.abs(s1.getX() - s2.getX()) > 5.0) {
                        return Double.compare(s1.getX(), s2.getX());
                    }
                    return Double.compare(s1.getY(), s2.getY());
                });
                if (sourceHeavier) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = SmartEdgeLabelModel.POSITION_TARGET_RIGHT;
                    nArray2[1] = SmartEdgeLabelModel.POSITION_RIGHT;
                    nArray = nArray2;
                    nArray2[2] = SmartEdgeLabelModel.POSITION_SOURCE_RIGHT;
                } else {
                    int[] nArray3 = new int[3];
                    nArray3[0] = SmartEdgeLabelModel.POSITION_SOURCE_RIGHT;
                    nArray3[1] = SmartEdgeLabelModel.POSITION_RIGHT;
                    nArray = nArray3;
                    nArray3[2] = SmartEdgeLabelModel.POSITION_TARGET_RIGHT;
                }
                int[] variants = nArray;
                int variantIdx = 0;
                for (Edge current : list) {
                    this.myEdgesPositions.put(current.index(), variants[variantIdx++]);
                    if (variantIdx < variants.length) continue;
                    variantIdx = 0;
                }
                return this.myEdgesPositions.get(edge.index());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update() {
                if (this.inUpdate) {
                    return;
                }
                try {
                    this.inUpdate = true;
                    this.myEdgeRealizers.clear();
                    List nodes = GraphUtil.getSelectedNodes((GraphBuilder)this.getGraphBuilder());
                    super.update();
                    this.myEdgesPositions.clear();
                    DiagramBuilder builder = this.getBuilder();
                    builder.relayout();
                    builder.getView().fitContent();
                    builder.updateView();
                    if (!nodes.isEmpty()) {
                        Collection objects = builder.getNodeObjects();
                        for (DiagramNode object : objects) {
                            if (!AngularUiRouterDiagramProvider.isInSelectedNodes(nodes, object)) continue;
                            builder.getGraph().setSelected(builder.getNode(object), true);
                        }
                    }
                    this.updateBySelection(nodes.isEmpty() ? null : (DiagramNode)nodes.get(0));
                }
                finally {
                    this.inUpdate = false;
                }
            }

            public void customizeSettings(final Graph2DView view, EditMode editMode) {
                super.customizeSettings(view, editMode);
                view.getGraph2D().addGraph2DSelectionListener(new Graph2DSelectionListener(){

                    public void onGraph2DSelectionEvent(Graph2DSelectionEvent _e) {
                        myEdgesPositions.clear();
                        this.updateBySelection(null);
                        view.updateView();
                    }
                });
                view.getJComponent().addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            UmlGraphBuilder builder = (UmlGraphBuilder)graph.getDataProvider((Object)"GRAPH_BUILDER").get(null);
                            builder.getPresentationModel().update();
                        });
                    }
                });
                ApplicationManager.getApplication().invokeLater(() -> {
                    UmlGraphBuilder builder = (UmlGraphBuilder)graph.getDataProvider((Object)"GRAPH_BUILDER").get(null);
                    AngularUiRouterDiagramModel model = (AngularUiRouterDiagramModel)builder.getDataModel();
                    AngularUiRouterNode rootNode = AngularUiRouterDiagramProvider.findDataObject(project, model).getRootNode();
                    this.updateBySelection((DiagramNode)rootNode);
                });
            }

            private void updateBySelection(DiagramNode node) {
                this.myVisibleEdges.clear();
                UmlGraphBuilder builder = (UmlGraphBuilder)graph.getDataProvider((Object)"GRAPH_BUILDER").get(null);
                ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>(GraphUtil.getSelectedNodes((GraphBuilder)builder));
                if (node != null && !nodes.contains(node)) {
                    nodes.add(node);
                }
                DiagramNode selected = null;
                for (DiagramEdge edge : builder.getEdgeObjects()) {
                    if (nodes.contains(edge.getSource())) {
                        selected = edge.getSource();
                        break;
                    }
                    if (!nodes.contains(edge.getTarget())) continue;
                    selected = edge.getTarget();
                    break;
                }
                if (selected == null) {
                    for (DiagramEdge edge : builder.getEdgeObjects()) {
                        if (AngularUiRouterDiagramProvider.isInSelectedNodes(nodes, edge.getSource())) {
                            selected = edge.getSource();
                            break;
                        }
                        if (!AngularUiRouterDiagramProvider.isInSelectedNodes(nodes, edge.getTarget())) continue;
                        selected = edge.getTarget();
                        break;
                    }
                }
                for (DiagramEdge edge : builder.getEdgeObjects()) {
                    if (!(edge instanceof AngularUiRouterEdge)) continue;
                    if (this.isShowEdgeLabels() && selected != null && (selected.equals(edge.getSource()) || selected.equals(edge.getTarget()))) {
                        this.myVisibleEdges.add((AngularUiRouterEdge)edge);
                        graph.setLabelText(builder.getEdge((Object)edge), ((AngularUiRouterEdge)edge).getLabel());
                        continue;
                    }
                    graph.setLabelText(builder.getEdge((Object)edge), "");
                }
            }

            public DefaultUmlRenderer getRenderer() {
                if (this.myRenderer == null) {
                    this.myRenderer = new DefaultUmlRenderer(this.getBuilder(), this.createModificationTracker()){

                        public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
                            wrapper.setBorder((Border)JBUI.Borders.empty());
                            if (wrapper.getParent() instanceof JComponent) {
                                ((JComponent)wrapper.getParent()).setBorder((Border)JBUI.Borders.empty());
                            }
                            super.tuneNode(realizer, wrapper);
                        }
                    };
                }
                return this.myRenderer;
            }
        };
    }

    private static boolean isInSelectedNodes(List<DiagramNode> nodes, DiagramNode node) {
        for (DiagramNode diagramNode : nodes) {
            if (!(node instanceof AngularUiRouterNode) || !(diagramNode instanceof AngularUiRouterNode)) continue;
            DiagramObject selected = (DiagramObject)diagramNode.getIdentifyingElement();
            DiagramObject object = (DiagramObject)node.getIdentifyingElement();
            if (!selected.getType().equals((Object)object.getType()) || !selected.getName().equals(object.getName()) || selected.getNavigationTarget() == null || object.getNavigationTarget() == null || !selected.getNavigationTarget().getVirtualFile().equals(object.getNavigationTarget().getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DiagramExtras<DiagramObject> getExtras() {
        DiagramExtras<DiagramObject> diagramExtras = new DiagramExtras<DiagramObject>(){

            public List<AnAction> getExtraActions() {
                return Collections.singletonList(new MyEditSourceAction());
            }

            @Nullable
            public Object getData(String dataId, List<DiagramNode<DiagramObject>> list, DiagramBuilder builder) {
                if (CommonDataKeys.PSI_ELEMENT.is(dataId) && list.size() == 1) {
                    SmartPsiElementPointer target = ((DiagramObject)list.get(0).getIdentifyingElement()).getNavigationTarget();
                    return target == null ? null : target.getElement();
                }
                if (JSModulesDiagramUtils.DIAGRAM_BUILDER.is(dataId)) {
                    return builder;
                }
                return null;
            }

            @Nullable
            public Layouter getCustomLayouter(Graph2D graph, Project project) {
                GraphSettingsProvider settingsProvider = GraphSettingsProvider.getInstance((Project)project);
                GraphSettings settings = settingsProvider.getSettings((Graph)graph);
                SmartOrganicLayouter layouter = settings.getOrganicLayouter();
                layouter.setNodeEdgeOverlapAvoided(true);
                layouter.setNodeSizeAware(true);
                layouter.setMinimalNodeDistance(60.0);
                layouter.setNodeOverlapsAllowed(false);
                layouter.setSmartComponentLayoutEnabled(true);
                layouter.setConsiderNodeLabelsEnabled(true);
                layouter.setDeterministic(true);
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(layouter);
                list.add(settings.getBalloonLayouter());
                list.add(settings.getCircularLayouter());
                list.add(settings.getDirectedOrthogonalLayouter());
                list.add(settings.getHVTreeLayouter());
                list.add(settings.getOrthogonalLayouter());
                for (CanonicMultiStageLayouter canonicMultiStageLayouter : list) {
                    ParallelEdgeLayouter parallelEdgeLayouter = GraphManager.getGraphManager().createParallelEdgeLayouter();
                    parallelEdgeLayouter.setLineDistance(40.0);
                    parallelEdgeLayouter.setUsingAdaptiveLineDistances(false);
                    canonicMultiStageLayouter.appendStage((LayoutStage)parallelEdgeLayouter);
                    canonicMultiStageLayouter.setParallelEdgeLayouterEnabled(false);
                }
                return layouter;
            }

            @NotNull
            public JComponent createNodeComponent(DiagramNode<DiagramObject> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
                DiagramNodeContainer container = new DiagramNodeContainer(node, builder, basePoint);
                if (!GraphViewUtil.isPrintMode()) {
                    if (!((DiagramObject)node.getIdentifyingElement()).getErrors().isEmpty()) {
                        container.setBorder(ERROR_BORDER);
                    } else if (!((DiagramObject)node.getIdentifyingElement()).getWarnings().isEmpty()) {
                        container.setBorder((Border)WARNING_BORDER);
                    } else {
                        container.setBorder(NORMAL_BORDER);
                    }
                }
                if (!((DiagramObject)node.getIdentifyingElement()).getChildrenList().isEmpty()) {
                    container.getHeader().setBorder(JBUI.Borders.customLine((Color)Gray._190, (int)0, (int)0, (int)1, (int)0));
                }
                DiagramNodeContainer diagramNodeContainer = container;
                if (diagramNodeContainer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/AngularUiRouterDiagramProvider$5", "createNodeComponent"));
                }
                return diagramNodeContainer;
            }
        };
        if (diagramExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/AngularUiRouterDiagramProvider", "getExtras"));
        }
        return diagramExtras;
    }

    private static AngularUiRouterGraphBuilder.GraphNodesBuilder findDataObject(Project project, AngularUiRouterDiagramModel model) {
        Collection<AngularUiRouterNode> nodes = model.getNodes();
        for (AngularUiRouterNode node : nodes) {
            if (!Type.topLevelTemplate.equals((Object)node.getIdentifyingElement().getType())) continue;
            VirtualFile rootFile = node.getIdentifyingElement().getNavigationTarget().getContainingFile().getVirtualFile();
            return AngularUiRouterProviderContext.getInstance(project).getBuilder(rootFile);
        }
        return null;
    }

    private static class MyEditSourceAction
    extends AnAction {
        private final AnAction myAction = ActionManager.getInstance().getAction("EditSource");

        public MyEditSourceAction() {
            super("Jump To...", "Jump To...", AllIcons.Actions.EditSource);
        }

        public void update(AnActionEvent e) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                e.getPresentation().setEnabled(false);
                return;
            }
            List nodes = JSModulesDiagramUtils.getSelectedNodes((AnActionEvent)e);
            e.getPresentation().setEnabled(nodes != null && nodes.size() == 1 && nodes.get(0) instanceof AngularUiRouterNode);
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            List nodes = JSModulesDiagramUtils.getSelectedNodes((AnActionEvent)e);
            if (nodes == null || nodes.size() != 1 || !(nodes.get(0) instanceof AngularUiRouterNode)) {
                return;
            }
            AngularUiRouterNode node = (AngularUiRouterNode)((Object)nodes.get(0));
            DiagramObject main = node.getIdentifyingElement();
            List<DiagramObject> childrenList = main.getChildrenList();
            if (childrenList.isEmpty()) {
                this.myAction.actionPerformed(e);
            } else {
                List children = childrenList.stream().map(ch -> Trinity.create((Object)(ch.getType().name() + ": " + ch.getName()), (Object)ch.getNavigationTarget(), (Object)null)).collect(Collectors.toList());
                JSModulesDiagramUtils.showMembersSelectionPopup((String)(main.getType().name() + ": " + main.getName()), (SmartPsiElementPointer)main.getNavigationTarget(), null, children, (DataContext)e.getDataContext());
            }
        }
    }
}

