/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.angularjs.codeInsight.router.AngularUiRouterNode;
import org.angularjs.codeInsight.router.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramObject {
    @NotNull
    private Type myType;
    @NotNull
    private final String myName;
    @Nullable
    private String myTooltip;
    @Nullable
    private final SmartPsiElementPointer myNavigationTarget;
    private boolean myIsValid;
    @NotNull
    private final List<String> myNotes;
    @NotNull
    private final List<String> myWarnings;
    @NotNull
    private final List<String> myErrors;
    private final Map<String, DiagramObject> myChildren;
    private final List<String> myChildOrder;
    private AngularUiRouterNode myContainer;
    private String myParentName;

    public DiagramObject(@NotNull Type type, @NotNull String name, @Nullable SmartPsiElementPointer navigationTarget) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/angularjs/codeInsight/router/DiagramObject", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/angularjs/codeInsight/router/DiagramObject", "<init>"));
        }
        this.myIsValid = true;
        this.myType = type;
        this.myName = name;
        this.myNavigationTarget = navigationTarget;
        this.myWarnings = new SmartList();
        this.myErrors = new SmartList();
        this.myNotes = new SmartList();
        this.myChildren = new HashMap<String, DiagramObject>();
        this.myChildOrder = new ArrayList<String>();
    }

    public void addChild(@NotNull DiagramObject child, AngularUiRouterNode parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/angularjs/codeInsight/router/DiagramObject", "addChild"));
        }
        this.myChildren.put(child.getName(), child);
        child.myContainer = parent;
        this.myChildOrder.add(child.getName());
    }

    public List<DiagramObject> getChildrenList() {
        ArrayList<DiagramObject> list = new ArrayList<DiagramObject>();
        for (String s : this.myChildOrder) {
            list.add(this.myChildren.get(s));
        }
        return list;
    }

    public AngularUiRouterNode getContainer() {
        return this.myContainer;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/DiagramObject", "getType"));
        }
        return type;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/DiagramObject", "getName"));
        }
        return string;
    }

    @Nullable
    public SmartPsiElementPointer getNavigationTarget() {
        return this.myNavigationTarget;
    }

    public void addError(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/angularjs/codeInsight/router/DiagramObject", "addError"));
        }
        this.myErrors.add(error);
        this.myIsValid = false;
    }

    public void addWarning(@NotNull String warning) {
        if (warning == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warning", "org/angularjs/codeInsight/router/DiagramObject", "addWarning"));
        }
        this.myWarnings.add(warning);
        this.myIsValid = false;
    }

    public void addNote(@NotNull String note) {
        if (note == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "note", "org/angularjs/codeInsight/router/DiagramObject", "addNote"));
        }
        this.myNotes.add(note);
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    @NotNull
    public List<String> getErrors() {
        List<String> list = this.myErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/DiagramObject", "getErrors"));
        }
        return list;
    }

    @NotNull
    public List<String> getWarnings() {
        List<String> list = this.myWarnings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/DiagramObject", "getWarnings"));
        }
        return list;
    }

    @NotNull
    public List<String> getNotes() {
        List<String> list = this.myNotes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/DiagramObject", "getNotes"));
        }
        return list;
    }

    @Nullable
    public String getTooltip() {
        return this.myTooltip == null ? this.myName : this.myTooltip;
    }

    public void setTooltip(@Nullable String tooltip) {
        this.myTooltip = tooltip;
    }

    public void setType(Type type) {
        this.myType = type;
    }

    public String getParent() {
        return this.myParentName;
    }

    public void setParent(String parentName) {
        this.myParentName = parentName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiagramObject object = (DiagramObject)o;
        if (this.myType != object.myType) {
            return false;
        }
        if (!this.myName.equals(object.myName)) {
            return false;
        }
        if (this.myTooltip != null ? !this.myTooltip.equals(object.myTooltip) : object.myTooltip != null) {
            return false;
        }
        if (this.myNavigationTarget != null ? !this.myNavigationTarget.equals(object.myNavigationTarget) : object.myNavigationTarget != null) {
            return false;
        }
        return !(this.myContainer != null ? !this.myContainer.equals((Object)object.myContainer) : object.myContainer != null);
    }

    public int hashCode() {
        int result = this.myType.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + (this.myTooltip != null ? this.myTooltip.hashCode() : 0);
        result = 31 * result + (this.myContainer != null ? this.myContainer.hashCode() : 0);
        return result;
    }
}

