/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.diagram.DiagramProvider;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.uml.core.actions.ShowDiagram;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import icons.AngularJSIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import org.angularjs.codeInsight.router.AngularUiRouterDiagramBuilder;
import org.angularjs.codeInsight.router.AngularUiRouterDiagramProvider;
import org.angularjs.codeInsight.router.AngularUiRouterGraphBuilder;
import org.angularjs.codeInsight.router.AngularUiRouterProviderContext;
import org.angularjs.codeInsight.router.DiagramObject;
import org.angularjs.codeInsight.router.RootTemplate;
import org.angularjs.codeInsight.router.UiRouterState;
import org.angularjs.index.AngularIndexUtil;

public class ShowUiRouterStatesNewDiagramAction
extends ShowDiagram {
    public static final String USAGE_KEY = "angular.js.ui.router.show.diagram";
    public static final String DESCRIPTION = "Show AngularJS ui-router State Diagram";

    public void actionPerformed(AnActionEvent e) {
        UsageTrigger.trigger((String)USAGE_KEY);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        AngularUiRouterDiagramProvider diagramProvider = (AngularUiRouterDiagramProvider)DiagramProvider.findByID((String)"Angular-ui-router");
        if (diagramProvider == null) {
            return;
        }
        ArrayList<Pair<String, AngularUiRouterGraphBuilder>> graphBuilders = new ArrayList<Pair<String, AngularUiRouterGraphBuilder>>();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            AngularUiRouterGraphBuilder graphBuilder;
            AngularUiRouterDiagramBuilder builder = new AngularUiRouterDiagramBuilder(project);
            builder.build();
            Map<VirtualFile, RootTemplate> rootTemplates = builder.getRootTemplates();
            for (Map.Entry<VirtualFile, Map<String, UiRouterState>> entry : builder.getDefiningFiles2States().entrySet()) {
                graphBuilder = new AngularUiRouterGraphBuilder(project, entry.getValue(), builder.getTemplatesMap(), null, entry.getKey());
                graphBuilders.add(Pair.create((Object)entry.getKey().getName(), (Object)graphBuilder));
            }
            for (Map.Entry<VirtualFile, Map<String, UiRouterState>> entry : builder.getRootTemplates2States().entrySet()) {
                graphBuilder = new AngularUiRouterGraphBuilder(project, entry.getValue(), builder.getTemplatesMap(), rootTemplates.get(entry.getKey()), entry.getKey());
                graphBuilders.add(Pair.create((Object)entry.getKey().getName(), (Object)graphBuilder));
            }
        }), "Building " + diagramProvider.getPresentableName() + " diagram", false, project);
        AngularUiRouterProviderContext routerProviderContext = AngularUiRouterProviderContext.getInstance(project);
        routerProviderContext.reset();
        Consumer consumer = graphBuilder -> {
            AngularUiRouterGraphBuilder.GraphNodesBuilder nodesBuilder = graphBuilder.createDataModel(diagramProvider);
            routerProviderContext.registerNodesBuilder(nodesBuilder);
            DiagramObject element = nodesBuilder.getRootNode().getIdentifyingElement();
            Runnable callback = this.show(element, (DiagramProvider)diagramProvider, project, null, Collections.emptyList());
            if (callback != null) {
                callback.run();
            }
        };
        if (graphBuilders.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)"No router states found.", (String)DESCRIPTION);
            return;
        }
        if (graphBuilders.size() == 1) {
            consumer.consume(((Pair)graphBuilders.get(0)).getSecond());
        } else {
            ShowUiRouterStatesNewDiagramAction.filterGraphBuilders(project, graphBuilders, (Consumer<AngularUiRouterGraphBuilder>)consumer);
        }
    }

    private static void filterGraphBuilders(Project project, List<Pair<String, AngularUiRouterGraphBuilder>> builders, Consumer<AngularUiRouterGraphBuilder> consumer) {
        JBList list = new JBList();
        ArrayList<String> data = new ArrayList<String>();
        for (Pair<String, AngularUiRouterGraphBuilder> builder : builders) {
            data.add(((AngularUiRouterGraphBuilder)builder.getSecond()).getKey().getPath());
        }
        list.setListData(ArrayUtil.toObjectArray(data));
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select Main Template File").setItemChoosenCallback(() -> {
            int index = list.getSelectedIndex();
            if (index >= 0) {
                consumer.consume(((Pair)builders.get(index)).getSecond());
            }
        }).createPopup().showCenteredInCurrentWindow(project);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && AngularIndexUtil.hasAngularJS(project) && !AngularIndexUtil.hasAngularJS2(project));
        e.getPresentation().setText(DESCRIPTION);
        e.getPresentation().setDescription(DESCRIPTION);
        e.getPresentation().setIcon(AngularJSIcons.AngularJS);
    }
}

