/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.router;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.List;
import org.angularjs.codeInsight.router.UiView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiRouterState {
    @NotNull
    private final String myName;
    private String myUrl;
    private String myTemplateUrl;
    private boolean myHasTemplateDefined;
    private String myParentName;
    private List<UiView> myViews;
    @Nullable
    private SmartPsiElementPointer<PsiElement> myPointer;
    private boolean myIsAbstract;
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private List<SmartPsiElementPointer<PsiElement>> myDuplicateDefinitions;
    private VirtualFile myTemplateFile;
    @Nullable
    private SmartPsiElementPointer<PsiElement> myTemplatePointer;
    private boolean myGeneric;

    public UiRouterState(@NotNull String name, @NotNull VirtualFile file) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/angularjs/codeInsight/router/UiRouterState", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/codeInsight/router/UiRouterState", "<init>"));
        }
        this.myName = name;
        this.myFile = file;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/UiRouterState", "getName"));
        }
        return string;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public String getTemplateUrl() {
        return this.myTemplateUrl;
    }

    public String getParentName() {
        return this.myParentName;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    public boolean isHasTemplateDefined() {
        return this.myHasTemplateDefined;
    }

    public void setHasTemplateDefined(boolean hasTemplateDefined) {
        this.myHasTemplateDefined = hasTemplateDefined;
    }

    public void setTemplateUrl(String templateUrl) {
        this.myTemplateUrl = templateUrl;
    }

    public void setParentName(String parentName) {
        this.myParentName = parentName;
    }

    public List<UiView> getViews() {
        return this.myViews;
    }

    public boolean hasViews() {
        return this.myViews != null && !this.myViews.isEmpty();
    }

    public void setViews(List<UiView> views) {
        this.myViews = views;
    }

    @Nullable
    public SmartPsiElementPointer<PsiElement> getPointer() {
        return this.myPointer;
    }

    public void setPointer(@Nullable SmartPsiElementPointer<PsiElement> pointer) {
        this.myPointer = pointer;
    }

    public boolean isAbstract() {
        return this.myIsAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.myIsAbstract = anAbstract;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/router/UiRouterState", "getFile"));
        }
        return virtualFile;
    }

    public void addDuplicateDefinition(@NotNull UiRouterState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/angularjs/codeInsight/router/UiRouterState", "addDuplicateDefinition"));
        }
        if (this.myDuplicateDefinitions == null) {
            this.myDuplicateDefinitions = new ArrayList<SmartPsiElementPointer<PsiElement>>();
        }
        this.myDuplicateDefinitions.add(state.getPointer());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UiRouterState state = (UiRouterState)o;
        if (!this.myName.equals(state.myName)) {
            return false;
        }
        if (this.myPointer != null ? !this.myPointer.equals(state.myPointer) : state.myPointer != null) {
            return false;
        }
        return this.myFile.equals(state.myFile);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (this.myPointer != null ? this.myPointer.hashCode() : 0);
        result = 31 * result + this.myFile.hashCode();
        return result;
    }

    public void setTemplateFile(VirtualFile templateFile) {
        this.myTemplateFile = templateFile;
    }

    public VirtualFile getTemplateFile() {
        return this.myTemplateFile;
    }

    public boolean isGeneric() {
        return this.myGeneric;
    }

    public void setGeneric(boolean generic) {
        this.myGeneric = generic;
    }

    @Nullable
    public SmartPsiElementPointer<PsiElement> getTemplatePointer() {
        return this.myTemplatePointer;
    }

    public void setTemplatePointer(@Nullable SmartPsiElementPointer<PsiElement> templatePointer) {
        this.myTemplatePointer = templatePointer;
    }
}

