/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.tags;

import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.xml.XmlDocumentImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularJSAttributeDescriptorsProvider;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AngularJSTagDescriptor
implements XmlElementDescriptor {
    protected final String myName;
    private final JSImplicitElement myDeclaration;

    public AngularJSTagDescriptor(String name, JSImplicitElement declaration) {
        this.myName = name;
        this.myDeclaration = declaration;
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlDocumentImpl xmlDocument = (XmlDocumentImpl)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocumentImpl.class);
        if (xmlDocument == null) {
            return EMPTY_ARRAY;
        }
        return xmlDocument.getRootTagNSDescriptor().getRootElementsDescriptors((XmlDocument)xmlDocument);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlTag parent = contextTag.getParentTag();
        if (parent == null) {
            return null;
        }
        XmlNSDescriptor descriptor = parent.getNSDescriptor(childTag.getNamespace(), true);
        return descriptor == null ? null : descriptor.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        Object[] result;
        JSImplicitElement declaration = this.getDeclaration();
        String string = declaration.getTypeString();
        String attributes = string.split(";", -1)[3];
        String[] split = attributes.split(",");
        if (context != null && AngularIndexUtil.hasAngularJS2(context.getProject())) {
            result = AngularAttributeDescriptor.getFieldBasedDescriptors(declaration);
        } else if (split.length == 1 && split[0].isEmpty()) {
            result = XmlAttributeDescriptor.EMPTY;
        } else {
            result = new XmlAttributeDescriptor[split.length];
            for (int i = 0; i < split.length; ++i) {
                result[i] = new AnyXmlAttributeDescriptor(DirectiveUtil.getAttributeName(split[i]));
            }
        }
        Object[] commonAttributes = HtmlNSDescriptorImpl.getCommonAttributeDescriptors((XmlTag)context);
        return (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])result, (Object[])commonAttributes);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        XmlAttributeDescriptor descriptor = (XmlAttributeDescriptor)ContainerUtil.find((Object[])this.getAttributesDescriptors(context), descriptor1 -> attributeName.equals(descriptor1.getName()));
        if (descriptor != null) {
            return descriptor;
        }
        return context != null ? AngularJSAttributeDescriptorsProvider.getAngular2Descriptor(attributeName, context.getProject()) : null;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return null;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return 1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public JSImplicitElement getDeclaration() {
        return this.myDeclaration;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myName;
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

