/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.editor;

import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.inject.JSInjectionUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.html.Angular2HTMLLanguage;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularJS2IndexingHandler;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2Injector
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        String name;
        int length;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/angularjs/editor/Angular2Injector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/editor/Angular2Injector", "getLanguagesToInject"));
        }
        Project project = context.getProject();
        if (!AngularIndexUtil.hasAngularJS2(project)) {
            return;
        }
        PsiElement parent = context.getParent();
        if (context instanceof JSLiteralExpressionImpl && ((JSLiteralExpressionImpl)context).isQuotedLiteral()) {
            if (this.injectIntoDirectiveProperty(registrar, context, parent, "template", (Language)Angular2HTMLLanguage.INSTANCE)) {
                return;
            }
            if (this.injectIntoEmbeddedLiteral(registrar, context, parent)) {
                return;
            }
            if (!(parent instanceof JSArrayLiteralExpression)) {
                return;
            }
            JSProperty property = (JSProperty)ObjectUtils.tryCast((Object)parent.getParent(), JSProperty.class);
            if (this.injectIntoDirectiveProperty(registrar, context, (PsiElement)property, "styles", (Language)CSSLanguage.INSTANCE)) {
                return;
            }
        }
        if (context instanceof XmlAttributeValueImpl && parent instanceof XmlAttribute && this.isInjectableAttribute(project, length = context.getTextLength(), name = ((XmlAttribute)parent).getName())) {
            registrar.startInjecting((Language)AngularJSLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, ElementManipulators.getValueTextRange((PsiElement)context)).doneInjecting();
        }
    }

    private boolean injectIntoEmbeddedLiteral(MultiHostRegistrar registrar, PsiElement context, PsiElement parent) {
        XmlAttribute attribute;
        if (parent instanceof JSEmbeddedContent && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parent, XmlAttribute.class)) != null && this.isInjectableAttribute(context.getProject(), context.getTextLength(), attribute.getName())) {
            TextRange range = ElementManipulators.getValueTextRange((PsiElement)context);
            registrar.startInjecting((Language)AngularJSLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, range).doneInjecting();
            return true;
        }
        return false;
    }

    protected boolean isInjectableAttribute(Project project, int valueLength, String name) {
        return (AngularAttributesRegistry.isEventAttribute(name, project) || AngularAttributesRegistry.isBindingAttribute(name, project) || AngularAttributesRegistry.isTemplateAttribute(name, project)) && valueLength > 0;
    }

    protected boolean injectIntoDirectiveProperty(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context, @Nullable PsiElement parent, @NotNull String name, @NotNull Language language) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/angularjs/editor/Angular2Injector", "injectIntoDirectiveProperty"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/editor/Angular2Injector", "injectIntoDirectiveProperty"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/angularjs/editor/Angular2Injector", "injectIntoDirectiveProperty"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/angularjs/editor/Angular2Injector", "injectIntoDirectiveProperty"));
        }
        if (parent instanceof JSProperty && name.equals(((JSProperty)parent).getName())) {
            JSExpression expression;
            JSCallExpression callExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSCallExpression.class);
            JSExpression jSExpression = expression = callExpression != null ? callExpression.getMethodExpression() : null;
            if (expression instanceof JSReferenceExpression) {
                String command = ((JSReferenceExpression)expression).getReferenceName();
                if (!AngularJS2IndexingHandler.isDirective(command) && !"View".equals(command)) {
                    return true;
                }
                TextRange range = ElementManipulators.getValueTextRange((PsiElement)context);
                registrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)context, range).doneInjecting();
                JSInjectionUtil.setReformattableInjection((MultiHostRegistrar)registrar);
            }
        }
        return false;
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PsiElement>> list = Arrays.asList(JSLiteralExpression.class, XmlAttributeValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/editor/Angular2Injector", "elementsToInjectIn"));
        }
        return list;
    }
}

