/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.editor;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularInjectionDelimiterIndex;

public class AngularJSBracesUtil {
    public static final String DEFAULT_START = "{{";
    public static final String DEFAULT_END = "}}";
    public static final Key<CachedValue<String>> START_KEY = Key.create((String)"angularjs.startSymbol");
    public static final Key<CachedValue<String>> END_KEY = Key.create((String)"angularjs.endSymbol");
    private static final Set<String> DEFAULT_CONFLICTS = new HashSet<String>(Arrays.asList("DjangoTemplate", "Jinja2", "Web2Py", "Handlebars", "Twig", "Blade"));

    public static String getInjectionStart(Project project) {
        return AngularJSBracesUtil.getInjectionDelimiter(project, START_KEY, DEFAULT_START);
    }

    public static String getInjectionEnd(Project project) {
        return AngularJSBracesUtil.getInjectionDelimiter(project, END_KEY, DEFAULT_END);
    }

    private static String getInjectionDelimiter(Project project, Key<CachedValue<String>> key, String defaultDelimiter) {
        return (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> {
            String id = key.toString();
            JSImplicitElement delimiter = AngularIndexUtil.resolve(project, AngularInjectionDelimiterIndex.KEY, id.substring(id.lastIndexOf(".") + 1));
            if (delimiter != null) {
                return CachedValueProvider.Result.create((Object)delimiter.getTypeString(), (Object[])new Object[]{delimiter});
            }
            return CachedValueProvider.Result.create((Object)defaultDelimiter, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    public static boolean hasConflicts(String start, String end, PsiElement element) {
        Language elementLanguage = element.getLanguage();
        if ("JSP".equals(elementLanguage.getDisplayName())) {
            return true;
        }
        PsiFile file = element.getContainingFile();
        if (DEFAULT_START.equals(start) || DEFAULT_END.equals(end)) {
            if (elementLanguage.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                return true;
            }
            for (Language language : file.getViewProvider().getLanguages()) {
                if (!DEFAULT_CONFLICTS.contains(language.getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }
}

