/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.editor;

import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.InjectorMatchingEndFinder;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Arrays;
import java.util.List;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.angularjs.editor.AngularJSBracesUtil;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;

public class AngularJSInjector
implements MultiHostInjector {
    private static final Logger LOG = Logger.getInstance(AngularJSInjector.class);

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/angularjs/editor/AngularJSInjector", "getLanguagesToInject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/editor/AngularJSInjector", "getLanguagesToInject"));
        }
        Project project = context.getProject();
        if (!AngularIndexUtil.hasAngularJS(project)) {
            return;
        }
        PsiElement parent = context.getParent();
        if (context instanceof XmlAttributeValueImpl && parent instanceof XmlAttribute) {
            String value = context.getText();
            int start = value.startsWith("'") || value.startsWith("\"") ? 1 : 0;
            int end = value.endsWith("'") || value.endsWith("\"") ? 1 : 0;
            int length = value.length();
            if (AngularAttributesRegistry.isAngularExpressionAttribute((XmlAttribute)parent) && length > 1) {
                registrar.startInjecting((Language)AngularJSLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(start, length - end)).doneInjecting();
                return;
            }
            if (AngularAttributesRegistry.isJSONAttribute((XmlAttribute)parent) && length > 1) {
                registrar.startInjecting((Language)JsonLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(start, length - end)).doneInjecting();
                return;
            }
        }
        if (context instanceof XmlTextImpl || context instanceof XmlAttributeValueImpl) {
            String end;
            String start = AngularJSBracesUtil.getInjectionStart(project);
            if (AngularJSBracesUtil.hasConflicts(start, end = AngularJSBracesUtil.getInjectionEnd(project), context)) {
                return;
            }
            String text = context.getText();
            int endIndex = -1;
            int afterStart = -1;
            while (true) {
                int startIdx;
                int n = afterStart = (startIdx = text.indexOf(start, Math.max(endIndex, afterStart))) < 0 ? -1 : startIdx + start.length();
                if (afterStart < 0) {
                    return;
                }
                endIndex = afterStart;
                endIndex = (endIndex = InjectorMatchingEndFinder.findMatchingEnd((String)start, (String)end, (String)text, (int)endIndex)) > 0 ? endIndex : ElementManipulators.getValueTextRange((PsiElement)context).getEndOffset();
                PsiElement injectionCandidate = afterStart >= 0 ? context.findElementAt(afterStart) : null;
                if (injectionCandidate == null || injectionCandidate.getNode().getElementType() == XmlTokenType.XML_COMMENT_CHARACTERS || injectionCandidate instanceof OuterLanguageElement) continue;
                if (afterStart > endIndex) {
                    if (ApplicationManager.getApplication().isInternal()) {
                        LOG.error("Braces: " + start + "," + end + "\nText: \"" + text + "\"\nInterval: (" + afterStart + "," + endIndex + ")\nFile: " + context.getContainingFile().getName() + ", language:" + context.getContainingFile().getLanguage());
                    }
                    return;
                }
                registrar.startInjecting((Language)AngularJSLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)context, new TextRange(afterStart, endIndex)).doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlTextImpl.class, XmlAttributeValueImpl.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/editor/AngularJSInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

