/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.html;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.HtmlLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import org.angularjs.html._AngularJSInterpolationsLexer;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.jetbrains.annotations.NotNull;

public class Angular2HTMLLexer
extends HtmlLexer {
    private static final int SEEN_ANGULAR_SCRIPT = 4096;
    private Lexer myInterpolationLexer;
    private int interpolationStart = -1;
    private boolean seenAngularScript;

    public Angular2HTMLLexer() {
        BaseHtmlLexer.TokenHandler value = new BaseHtmlLexer.TokenHandler(){

            public void handleElement(Lexer lexer) {
                if (!Angular2HTMLLexer.this.isHtmlTagState(lexer.getState())) {
                    String text = lexer.getTokenText();
                    if (text.startsWith("(") || text.startsWith("[") || text.startsWith("*")) {
                        Angular2HTMLLexer.this.seenAttribute = true;
                        Angular2HTMLLexer.this.seenScript = true;
                        Angular2HTMLLexer.this.seenAngularScript = true;
                    } else {
                        Angular2HTMLLexer.this.seenAngularScript = false;
                    }
                }
            }
        };
        this.registerHandler(XmlTokenType.XML_NAME, value);
        BaseHtmlLexer.TokenHandler scriptCleaner = new BaseHtmlLexer.TokenHandler(){

            public void handleElement(Lexer lexer) {
                Angular2HTMLLexer.this.seenAngularScript = false;
            }
        };
        this.registerHandler(XmlTokenType.XML_TAG_END, scriptCleaner);
        this.registerHandler(XmlTokenType.XML_END_TAG_START, scriptCleaner);
        this.registerHandler(XmlTokenType.XML_EMPTY_ELEMENT_END, scriptCleaner);
        this.registerHandler(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, scriptCleaner);
    }

    public void advance() {
        if (this.myInterpolationLexer != null) {
            this.myInterpolationLexer.advance();
            try {
                if (this.myInterpolationLexer.getTokenType() != null) {
                    return;
                }
            }
            catch (Error error) {
                Logger.getInstance(Angular2HTMLLexer.class).error((Object)this.myInterpolationLexer.getBufferSequence());
            }
            this.myInterpolationLexer = null;
            this.interpolationStart = -1;
            return;
        }
        super.advance();
        IElementType originalType = super.getTokenType();
        if (originalType == XmlTokenType.XML_DATA_CHARACTERS || originalType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            IElementType type = originalType;
            this.interpolationStart = super.getTokenStart();
            StringBuilder text = new StringBuilder();
            while (type == XmlTokenType.XML_DATA_CHARACTERS || type == XmlTokenType.XML_REAL_WHITE_SPACE || type == XmlTokenType.XML_WHITE_SPACE || type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || type == XmlTokenType.XML_CHAR_ENTITY_REF || type == XmlTokenType.XML_ENTITY_REF_TOKEN) {
                text.append(super.getTokenText());
                super.advance();
                type = this.getTokenType();
            }
            Lexer lexer = Angular2HTMLLexer.createLexer(originalType);
            lexer.start((CharSequence)text);
            this.myInterpolationLexer = lexer;
        }
    }

    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (type == JSElementTypes.EMBEDDED_CONTENT && this.seenAngularScript) {
            return AngularJSElementTypes.EMBEDDED_CONTENT;
        }
        if (this.myInterpolationLexer != null) {
            return this.myInterpolationLexer.getTokenType();
        }
        return type;
    }

    public int getTokenStart() {
        if (this.myInterpolationLexer != null) {
            return this.interpolationStart + this.myInterpolationLexer.getTokenStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myInterpolationLexer != null) {
            return this.interpolationStart + this.myInterpolationLexer.getTokenEnd();
        }
        return super.getTokenEnd();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/angularjs/html/Angular2HTMLLexer", "start"));
        }
        this.myInterpolationLexer = null;
        this.interpolationStart = -1;
        this.seenAngularScript = (initialState & 0x1000) != 0;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    public int getState() {
        int state = super.getState();
        return state | (this.seenAngularScript ? 4096 : 0);
    }

    private static Lexer createLexer(IElementType type) {
        _AngularJSInterpolationsLexer lexer = new _AngularJSInterpolationsLexer(null);
        lexer.setType(type);
        return new MergingLexerAdapter((Lexer)new FlexAdapter((FlexLexer)lexer), TokenSet.create((IElementType[])new IElementType[]{AngularJSElementTypes.EMBEDDED_CONTENT, XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN}));
    }
}

