/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularNamedItemDefinition;
import org.jetbrains.annotations.NotNull;

public class AngularAttributeIndexer
implements DataIndexer<String, AngularNamedItemDefinition, FileContent> {
    private final String myAttributeName;

    public AngularAttributeIndexer(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/angularjs/index/AngularAttributeIndexer", "<init>"));
        }
        this.myAttributeName = attributeName;
    }

    @NotNull
    public Map<String, AngularNamedItemDefinition> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/angularjs/index/AngularAttributeIndexer", "map"));
        }
        final HashMap<String, AngularNamedItemDefinition> map = new HashMap<String, AngularNamedItemDefinition>();
        PsiFile file = inputData.getPsiFile();
        if (file instanceof XmlFile) {
            file.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlAttribute(XmlAttribute attribute) {
                    if (AngularAttributeIndexer.this.myAttributeName.equals(DirectiveUtil.normalizeAttributeName(attribute.getName()))) {
                        XmlAttributeValue element = attribute.getValueElement();
                        if (element == null) {
                            map.put("", new AngularNamedItemDefinition("", attribute.getTextRange().getStartOffset()));
                        } else {
                            String name = StringUtil.unquoteString((String)element.getText());
                            map.put(name, new AngularNamedItemDefinition(name, element.getTextRange().getStartOffset()));
                        }
                    }
                }
            });
        }
        HashMap<String, AngularNamedItemDefinition> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/index/AngularAttributeIndexer", "map"));
        }
        return hashMap;
    }
}

