/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularInjectionDelimiterIndex;
import org.angularjs.index.AngularJSIndexingHandler;
import org.angularjs.index.AngularNamedItemDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularIndexUtil {
    public static final int BASE_VERSION = 51;
    private static final ConcurrentMap<String, Key<ParameterizedCachedValue<Collection<String>, Pair<Project, ID<String, ?>>>>> ourCacheKeys = ContainerUtil.newConcurrentMap();
    private static final AngularKeysProvider PROVIDER = new AngularKeysProvider();
    public static final Function<JSImplicitElement, ResolveResult> JS_IMPLICIT_TO_RESOLVE_RESULT = JSResolveResult::new;

    public static JSImplicitElement resolve(Project project, StubIndexKey<String, JSImplicitElementProvider> index, String lookupKey) {
        Ref result = new Ref(null);
        Processor processor = element -> {
            if (element.getName().equals(lookupKey) && (index == AngularInjectionDelimiterIndex.KEY || AngularJSIndexingHandler.isAngularRestrictions(element.getTypeString()))) {
                result.set(element);
                if (DialectDetector.isTypeScript((PsiElement)element)) {
                    return false;
                }
            }
            return true;
        };
        AngularIndexUtil.multiResolve(project, index, lookupKey, (Processor<JSImplicitElement>)processor);
        return (JSImplicitElement)result.get();
    }

    public static void multiResolve(Project project, StubIndexKey<String, JSImplicitElementProvider> index, String lookupKey, Processor<JSImplicitElement> processor) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        StubIndex.getInstance().processElements(index, (Object)lookupKey, project, scope, JSImplicitElementProvider.class, provider -> {
            Collection elements;
            JSElementIndexingData indexingData = provider.getIndexingData();
            if (indexingData != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    if (processor.process((Object)element)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public static ResolveResult[] multiResolveAngularNamedDefinitionIndex(@NotNull Project project, @NotNull ID<String, AngularNamedItemDefinition> INDEX, @NotNull String id, @NotNull Condition<VirtualFile> filter, boolean dirtyResolve) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/index/AngularIndexUtil", "multiResolveAngularNamedDefinitionIndex"));
        }
        if (INDEX == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "INDEX", "org/angularjs/index/AngularIndexUtil", "multiResolveAngularNamedDefinitionIndex"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/angularjs/index/AngularIndexUtil", "multiResolveAngularNamedDefinitionIndex"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/angularjs/index/AngularIndexUtil", "multiResolveAngularNamedDefinitionIndex"));
        }
        FileBasedIndex instance = FileBasedIndex.getInstance();
        Collection files = instance.getContainingFiles(INDEX, (Object)id, GlobalSearchScope.allScope((Project)project));
        if (files.isEmpty()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        List filtered = ContainerUtil.filter((Collection)files, filter);
        if (filtered.isEmpty()) {
            if (!dirtyResolve) {
                return ResolveResult.EMPTY_ARRAY;
            }
        } else {
            files = filtered;
        }
        ArrayList<JSOffsetBasedImplicitElement> elements = new ArrayList<JSOffsetBasedImplicitElement>();
        for (VirtualFile file : files) {
            List values = instance.getValues(INDEX, (Object)id, GlobalSearchScope.fileScope((Project)project, (VirtualFile)file));
            for (AngularNamedItemDefinition value : values) {
                JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedName((String)id);
                JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder((JSQualifiedName)qName, null);
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) continue;
                elements.add(new JSOffsetBasedImplicitElement(elementBuilder, (int)value.getStartOffset(), psiFile));
            }
        }
        List list = ContainerUtil.map(elements, JS_IMPLICIT_TO_RESOLVE_RESULT);
        return list.toArray(new ResolveResult[list.size()]);
    }

    public static Collection<String> getAllKeys(ID<String, ?> index, Project project) {
        String indexId = index.toString();
        Key key = (Key)ConcurrencyUtil.cacheOrGet(ourCacheKeys, (Object)indexId, (Object)Key.create((String)("angularjs.index." + indexId)));
        Pair pair = Pair.create((Object)project, index);
        return (Collection)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, key, (ParameterizedCachedValueProvider)PROVIDER, false, (Object)pair);
    }

    public static boolean hasAngularJS(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && "disabled".equals(System.getProperty("angular.js"))) {
            return false;
        }
        return AngularIndexUtil.getAngularJSVersion(project) > 0;
    }

    public static boolean hasAngularJS2(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && "disabled".equals(System.getProperty("angular.js"))) {
            return false;
        }
        return AngularIndexUtil.getAngularJSVersion(project) >= 20;
    }

    private static int getAngularJSVersion(Project project) {
        if (DumbService.isDumb((Project)project)) {
            return -1;
        }
        return (Integer)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            int version = -1;
            JSImplicitElement resolve = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, "[ngFor]");
            if (resolve != null) {
                version = 20;
            } else {
                resolve = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, "ng-messages");
                if (resolve != null) {
                    version = 13;
                } else {
                    resolve = AngularIndexUtil.resolve(project, AngularDirectivesIndex.KEY, "ng-model");
                    if (resolve != null) {
                        version = 12;
                    }
                }
            }
            if (resolve != null) {
                return CachedValueProvider.Result.create((Object)version, (Object[])new Object[]{resolve.getContainingFile()});
            }
            return CachedValueProvider.Result.create((Object)version, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootModificationTracker.getInstance((Project)project)});
        });
    }

    public static String convertRestrictions(Project project, String restrictions) {
        if ("D".equals(restrictions)) {
            return AngularIndexUtil.getAngularJSVersion(project) >= 13 ? "AE" : "A";
        }
        return restrictions;
    }

    private static class AngularKeysProvider
    implements ParameterizedCachedValueProvider<Collection<String>, Pair<Project, ID<String, ?>>> {
        private AngularKeysProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<Collection<String>> compute(Pair<Project, ID<String, ?>> projectAndIndex) {
            Project project = (Project)projectAndIndex.first;
            ID id = (ID)projectAndIndex.second;
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            FileBasedIndex fileIndex = FileBasedIndex.getInstance();
            StubIndex stubIndex = StubIndex.getInstance();
            Collection allKeys = id instanceof StubIndexKey ? stubIndex.getAllKeys((StubIndexKey)id, project) : fileIndex.getAllKeys(id, project);
            return CachedValueProvider.Result.create((Object)ContainerUtil.filter((Collection)allKeys, key -> id instanceof StubIndexKey ? !stubIndex.processElements((StubIndexKey)id, key, project, scope, PsiElement.class, element -> false) : !fileIndex.processValues(id, key, null, new FileBasedIndex.ValueProcessor(){

                public boolean process(VirtualFile file, Object value) {
                    return false;
                }
            }, scope)), (Object[])new Object[]{PsiManager.getInstance((Project)project).getModificationTracker()});
        }
    }
}

