/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.index;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.List;
import org.angularjs.html.Angular2HTMLLanguage;
import org.angularjs.index.AngularJSIndexingHandler;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJS2IndexingHandler
extends FrameworkIndexingHandler {
    public static final String TEMPLATE_REF = "TemplateRef";
    public static final String SELECTOR = "selector";
    public static final String NAME = "name";

    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJS2IndexingHandler", "processCallExpression"));
        }
        JSExpression expression = callExpression.getMethodExpression();
        if (expression instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)expression).getReferenceName();
            if (AngularJS2IndexingHandler.isDirective(name)) {
                AngularJS2IndexingHandler.addImplicitElement((PsiElement)callExpression, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.getPropertyName((PsiElement)callExpression, SELECTOR));
            }
            if (AngularJS2IndexingHandler.isPipe(name)) {
                AngularJS2IndexingHandler.addPipe((PsiElement)callExpression, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.getPropertyName((PsiElement)callExpression, NAME));
            }
            if (AngularJS2IndexingHandler.isModule(name)) {
                AngularJS2IndexingHandler.addImplicitElementToModules((PsiElement)callExpression, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.determineModuleName(callExpression));
            }
        }
    }

    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        JSExpression value;
        JSObjectLiteralExpression object;
        JSProperty type;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/angularjs/index/AngularJS2IndexingHandler", "processAnyProperty"));
        }
        if ("args".equals(property.getName()) && (type = (object = (JSObjectLiteralExpression)property.getParent()).findProperty("type")) != null && (value = type.getValue()) instanceof JSReferenceExpression && AngularJS2IndexingHandler.isDirective(((JSReferenceExpression)value).getReferenceName())) {
            return AngularJS2IndexingHandler.addImplicitElement((PsiElement)property, (JSElementIndexingDataImpl)outData, AngularJS2IndexingHandler.getPropertyName((PsiElement)property, SELECTOR));
        }
        return super.processAnyProperty(property, outData);
    }

    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode name;
        ASTNode ref = node.getFirstChildNode();
        if (ref.getElementType() == JSTokenTypes.NEW_KEYWORD) {
            ref = TreeUtil.findSibling((ASTNode)ref, (IElementType)JSElementTypes.REFERENCE_EXPRESSION);
        }
        if (ref != null && (name = ref.getLastChildNode()) != null && name.getElementType() == JSTokenTypes.IDENTIFIER) {
            String referencedName = name.getText();
            return AngularJS2IndexingHandler.isDirective(referencedName) || AngularJS2IndexingHandler.isPipe(referencedName) || AngularJS2IndexingHandler.isModule(referencedName);
        }
        return false;
    }

    private static String determineModuleName(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/angularjs/index/AngularJS2IndexingHandler", "determineModuleName"));
        }
        if (!(callExpression.getParent() instanceof ES6Decorator)) {
            return null;
        }
        ES6Decorator decorator = (ES6Decorator)callExpression.getParent();
        PsiElement owner = decorator.getOwner();
        if (owner instanceof JSClass) {
            return ((JSClass)owner).getName();
        }
        return null;
    }

    private static void iterateSelectorNames(@Nullable String selector, @NotNull Consumer<String> consumer) {
        String[] names;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/angularjs/index/AngularJS2IndexingHandler", "iterateSelectorNames"));
        }
        if (selector == null) {
            return;
        }
        for (String selectorName : names = selector.split("\\s*,\\s*")) {
            int not = selectorName.indexOf(58);
            if (not >= 0) {
                String tail;
                String head = selectorName.substring(0, not);
                int brace = selectorName.indexOf(41, not);
                String string = tail = brace >= 0 ? selectorName.substring(brace + 1) : "";
                if (!StringUtil.isEmpty((String)head)) {
                    consumer.consume((Object)head);
                }
                if (StringUtil.isEmpty((String)tail)) continue;
                consumer.consume((Object)tail);
                continue;
            }
            if (StringUtil.isEmpty((String)selectorName)) continue;
            consumer.consume((Object)selectorName);
        }
    }

    private static void addImplicitElementToModules(PsiElement decorator, @NotNull JSElementIndexingDataImpl outData, String selector) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJS2IndexingHandler", "addImplicitElementToModules"));
        }
        if (selector == null) {
            return;
        }
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(selector, decorator).setUserString("ami");
        outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
    }

    private static JSElementIndexingDataImpl addImplicitElement(PsiElement element, JSElementIndexingDataImpl outData, String selector) {
        if (selector == null) {
            return outData;
        }
        Ref ref = new Ref((Object)outData);
        HashSet added = new HashSet();
        AngularJS2IndexingHandler.iterateSelectorNames(selector, (Consumer<String>)((Consumer)selectorName -> {
            int start = selectorName.indexOf(91);
            int end = selectorName.indexOf(93);
            if (start == 0 && end > 0 || start < 0 && end < 0) {
                JSImplicitElementImpl.Builder elementBuilder;
                if (ref.isNull()) {
                    ref.set((Object)new JSElementIndexingDataImpl());
                }
                for (String attr : StringUtil.split((String)selectorName, (String)"]", (boolean)false)) {
                    if (added.contains(attr)) continue;
                    String restrict = selectorName.startsWith("[") ? "A" : "E";
                    elementBuilder = new JSImplicitElementImpl.Builder(attr, element).setType(JSImplicitElement.Type.Class).setTypeString(restrict + ";template;;");
                    elementBuilder.setUserString("adi");
                    ((JSElementIndexingDataImpl)ref.get()).addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
                    added.add(attr);
                }
                if (end > start) {
                    String attributeName = selectorName.substring(1, end);
                    String prefix = AngularJS2IndexingHandler.isTemplate(element) ? "*" : "";
                    String attr = prefix + attributeName;
                    if (added.contains(attr)) {
                        return;
                    }
                    elementBuilder = new JSImplicitElementImpl.Builder(attr, element).setType(JSImplicitElement.Type.Class).setTypeString("A;;;");
                    elementBuilder.setUserString("adi");
                    ((JSElementIndexingDataImpl)ref.get()).addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
                    added.add(attr);
                }
            }
        }));
        return (JSElementIndexingDataImpl)ref.get();
    }

    private static void addPipe(PsiElement expression, @NotNull JSElementIndexingDataImpl outData, String pipe) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "org/angularjs/index/AngularJS2IndexingHandler", "addPipe"));
        }
        if (pipe == null) {
            return;
        }
        JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(pipe, expression).setUserString("afi");
        outData.addImplicitElement((JSImplicitElement)elementBuilder.toImplicitElement());
    }

    private static boolean isTemplate(PsiElement decorator) {
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)decorator, JSClass.class);
        if (clazz != null) {
            JSFunction constructor = clazz.getConstructor();
            JSParameterList params = constructor != null ? constructor.getParameterList() : null;
            return params != null && params.getText().contains(TEMPLATE_REF);
        }
        PsiElement parent = decorator.getParent();
        if (parent instanceof JSArrayLiteralExpression) {
            JSCallExpression metadata = (JSCallExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)decorator, JSCallExpression.class);
            return AngularJS2IndexingHandler.hasTemplateRef((PsiElement)metadata);
        }
        if (parent instanceof JSObjectLiteralExpression) {
            JSStatement[] statements;
            JSFile file;
            JSQualifiedName namespace = AngularJS2IndexingHandler.getCompiledDecoratorNamespace(parent);
            if (namespace == null) {
                return false;
            }
            JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, JSBlockStatement.class);
            JSFile jSFile = file = block == null ? (JSFile)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFile.class) : null;
            for (JSStatement statement : statements = block != null ? block.getStatements() : (file != null ? file.getStatements() : JSStatement.EMPTY)) {
                JSDefinitionExpression def;
                JSExpression expression;
                if (!(statement instanceof JSExpressionStatement) || !((expression = ((JSExpressionStatement)statement).getExpression()) instanceof JSAssignmentExpression) || (def = ((JSAssignmentExpression)expression).getDefinitionExpression()) == null || !"ctorParameters".equals(def.getName()) || !namespace.equals(def.getJSNamespace().getQualifiedName())) continue;
                return AngularJS2IndexingHandler.hasTemplateRef((PsiElement)expression) || PsiTreeUtil.hasErrorElements((PsiElement)expression) && !DialectDetector.isES6((PsiElement)expression) && AngularJS2IndexingHandler.hasTemplateRef(PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, JSExpressionStatement.class));
            }
        }
        return false;
    }

    private static boolean hasTemplateRef(@Nullable PsiElement expression) {
        return expression != null && expression.getText().contains(TEMPLATE_REF);
    }

    private static JSQualifiedName getCompiledDecoratorNamespace(PsiElement parent) {
        JSAssignmentExpression assignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, JSAssignmentExpression.class, (boolean)true, (Class[])new Class[]{JSFunction.class, JSFile.class});
        JSDefinitionExpression definition = assignment != null ? assignment.getDefinitionExpression() : null;
        return definition != null ? definition.getJSNamespace().getQualifiedName() : null;
    }

    @Nullable
    private static String getPropertyName(PsiElement decorator, String name) {
        JSExpression value;
        JSProperty selector = AngularJS2IndexingHandler.getProperty(decorator, name);
        JSExpression jSExpression = value = selector != null ? selector.getValue() : null;
        if (value instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return AngularJSIndexingHandler.unquote((PsiElement)value);
        }
        return null;
    }

    @Nullable
    public static JSProperty getSelector(PsiElement decorator) {
        return AngularJS2IndexingHandler.getProperty(decorator instanceof ES6Decorator ? PsiTreeUtil.findChildOfType((PsiElement)decorator, JSCallExpression.class) : decorator, SELECTOR);
    }

    @Nullable
    private static JSProperty getProperty(PsiElement decorator, String name) {
        JSExpression[] arguments;
        JSArgumentList argumentList = (JSArgumentList)PsiTreeUtil.getChildOfType((PsiElement)decorator, JSArgumentList.class);
        JSExpression[] jSExpressionArray = arguments = argumentList != null ? argumentList.getArguments() : null;
        if (arguments == null) {
            JSArrayLiteralExpression array = (JSArrayLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)decorator, JSArrayLiteralExpression.class);
            arguments = array != null ? array.getExpressions() : null;
        }
        JSObjectLiteralExpression descriptor = (JSObjectLiteralExpression)ObjectUtils.tryCast(arguments != null && arguments.length > 0 ? arguments[0] : null, JSObjectLiteralExpression.class);
        return descriptor != null ? descriptor.findProperty(name) : null;
    }

    public static boolean isDirective(@Nullable String name) {
        return "Directive".equals(name) || "DirectiveAnnotation".equals(name) || "Component".equals(name) || "ComponentAnnotation".equals(name);
    }

    public static boolean isModule(@Nullable String name) {
        return "NgModule".equals(name);
    }

    private static boolean isPipe(@Nullable String name) {
        return "Pipe".equals(name);
    }

    public void addContextType(BaseJSSymbolProcessor.TypeInfo info, PsiElement context) {
        JSQualifiedName directiveNamespace;
        if (context instanceof JSReferenceExpression && ((JSReferenceExpression)context).getQualifier() == null && (directiveNamespace = AngularJS2IndexingHandler.findDirective(context)) != null) {
            info.addType((JSNamespace)new JSNamespaceImpl(directiveNamespace, JSContext.INSTANCE, true), false);
        }
    }

    public void addContextNames(PsiElement context, List<String> names) {
        JSQualifiedName directiveNamespace;
        if (context instanceof JSReferenceExpression && ((JSReferenceExpression)context).getQualifier() == null && (directiveNamespace = AngularJS2IndexingHandler.findDirective(context)) != null) {
            names.add(directiveNamespace.getQualifiedName());
        }
    }

    @Nullable
    private static JSQualifiedName findDirective(PsiElement context) {
        JSClass clazz = AngularJS2IndexingHandler.findDirectiveClass(context);
        return clazz != null ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)clazz) : null;
    }

    @Nullable
    public static JSClass findDirectiveClass(PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (file.getLanguage().is((Language)Angular2HTMLLanguage.INSTANCE)) {
            return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)file), JSClass.class);
        }
        if (file.getLanguage().is((Language)AngularJSLanguage.INSTANCE)) {
            PsiFile directiveFile;
            PsiElement original = CompletionUtil.getOriginalOrSelf((PsiElement)context);
            PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)(original != context ? original : context.getContainingFile().getOriginalFile()));
            String name = hostFile != null ? hostFile.getVirtualFile().getNameWithoutExtension() : null;
            PsiDirectory dir = hostFile != null ? hostFile.getParent() : null;
            PsiFile psiFile = directiveFile = dir != null ? dir.findFile(name + ".ts") : null;
            if (directiveFile != null) {
                for (PsiElement element : directiveFile.getChildren()) {
                    if (!(element instanceof JSClass)) continue;
                    return (JSClass)element;
                }
            }
        }
        return null;
    }

    public int getVersion() {
        return 51;
    }
}

