/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import org.angularjs.codeInsight.attributes.AngularAttributesRegistry;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyEventHandlerInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/angularjs/inspections/EmptyEventHandlerInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlAttributeValue value;
                if (AngularAttributesRegistry.isEventAttribute(attribute.getName(), attribute.getProject()) && ((value = attribute.getValueElement()) == null || value.getChildren().length == 0)) {
                    holder.registerProblem((PsiElement)attribute, "Empty event handler attribute", new LocalQuickFix[]{new CreateAttributeQuickFix()});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/inspections/EmptyEventHandlerInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static class CreateAttributeQuickFix
    implements LocalQuickFix {
        private CreateAttributeQuickFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            if ("Add attribute value" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/inspections/EmptyEventHandlerInspection$CreateAttributeQuickFix", "getName"));
            }
            return "Add attribute value";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("AngularJS" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/inspections/EmptyEventHandlerInspection$CreateAttributeQuickFix", "getFamilyName"));
            }
            return "AngularJS";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/angularjs/inspections/EmptyEventHandlerInspection$CreateAttributeQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/angularjs/inspections/EmptyEventHandlerInspection$CreateAttributeQuickFix", "applyFix"));
            }
            XmlAttribute attribute = (XmlAttribute)descriptor.getPsiElement();
            attribute.setValue("");
            new OpenFileDescriptor(project, attribute.getContainingFile().getVirtualFile(), attribute.getValueElement().getTextRange().getStartOffset() + 1).navigate(true);
        }
    }
}

