/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.angularjs.codeInsight.AngularJSPluralCategories;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.parser.AngularJSParser;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AngularJSMessageFormatParser
extends ExpressionParser<AngularJSParser> {
    @NonNls
    public static final String OFFSET_OPTION = "offset";
    private boolean myInsideSelectExpression;

    public AngularJSMessageFormatParser(@NotNull AngularJSParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/angularjs/lang/parser/AngularJSMessageFormatParser", "<init>"));
        }
        super((JavaScriptParser)parser);
        this.myInsideSelectExpression = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseMessage() {
        if (this.myInsideSelectExpression) {
            return false;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            return AngularJSMessageFormatParser.rollback(expr);
        }
        PsiBuilder.Marker refMark = this.builder.mark();
        this.myInsideSelectExpression = true;
        try {
            if (!((AngularJSParser.AngularJSExpressionParser)((AngularJSParser)this.myJavaScriptParser).getExpressionParser()).parseUnaryExpression()) {
                boolean bl = AngularJSMessageFormatParser.rollback(expr);
                return bl;
            }
        }
        finally {
            this.myInsideSelectExpression = false;
        }
        refMark.done(JSElementTypes.EXPRESSION_STATEMENT);
        if (this.builder.getTokenType() != JSTokenTypes.COMMA) {
            return AngularJSMessageFormatParser.rollback(expr);
        }
        this.builder.advanceLexer();
        String extensionText = this.builder.getTokenText();
        if (!AngularJSMessageFormatParser.isKnownExtension(extensionText) || !this.isIdentifierToken(this.builder.getTokenType())) {
            return AngularJSMessageFormatParser.rollback(expr);
        }
        this.collapseTokenElement(AngularJSElementTypes.MESSAGE_FORMAT_EXPRESSION_NAME);
        if (this.builder.getTokenType() != JSTokenTypes.COMMA) {
            return AngularJSMessageFormatParser.rollback(expr);
        }
        this.builder.advanceLexer();
        if (ExtensionType.select.name().equals(extensionText)) {
            this.parseOptionsTail();
        } else {
            this.parsePluralTail();
        }
        expr.done(AngularJSElementTypes.MESSAGE_FORMAT_EXPRESSION);
        return true;
    }

    public boolean parseInnerMessage() {
        PsiBuilder.Marker mark = this.builder.mark();
        PsiBuilder.Marker stringLiteralMark = null;
        while (!this.builder.eof()) {
            IElementType type = this.builder.getTokenType();
            if (JSTokenTypes.LBRACE == type || JSTokenTypes.RBRACE == type) {
                if (stringLiteralMark != null) {
                    stringLiteralMark.collapse(JSTokenTypes.STRING_LITERAL);
                    stringLiteralMark = null;
                }
                if (JSTokenTypes.LBRACE == type) {
                    if (JSTokenTypes.LBRACE == this.builder.lookAhead(1)) {
                        this.builder.advanceLexer();
                        this.builder.advanceLexer();
                        ((AngularJSParser.AngularJSExpressionParser)((AngularJSParser)this.myJavaScriptParser).getExpressionParser()).parseExpression();
                        if (this.expectDoubleRBrace(true)) continue;
                        mark.drop();
                        return false;
                    }
                    this.builder.error("expected {{");
                    mark.drop();
                    return false;
                }
                if (JSTokenTypes.RBRACE != type) continue;
                mark.done(AngularJSElementTypes.MESSAGE_FORMAT_MESSAGE);
                this.builder.advanceLexer();
                return true;
            }
            if (stringLiteralMark == null) {
                stringLiteralMark = this.builder.mark();
            }
            this.builder.advanceLexer();
        }
        if (stringLiteralMark != null) {
            stringLiteralMark.drop();
        }
        mark.drop();
        return false;
    }

    private boolean expectDoubleRBrace(boolean advance) {
        if (!AngularJSMessageFormatParser.isRBraceOrNull(this.builder.getTokenType()) || !AngularJSMessageFormatParser.isRBraceOrNull(this.builder.lookAhead(1))) {
            this.builder.error("expected }}");
            return false;
        }
        if (advance) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
        }
        return true;
    }

    private static boolean isRBraceOrNull(IElementType type) {
        return type == null || JSTokenTypes.RBRACE == type;
    }

    private void parsePluralTail() {
        if (!this.parseOffsetOption()) {
            return;
        }
        this.parseOptionsTail();
    }

    private boolean parseOffsetOption() {
        if (this.isIdentifierToken(this.builder.getTokenType()) && OFFSET_OPTION.equals(this.builder.getTokenText())) {
            if (this.builder.lookAhead(1) != JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.builder.error("expected colon");
                return false;
            }
            IElementType value = this.builder.lookAhead(2);
            if (!JSTokenTypes.LITERALS.contains(value) && JSTokenTypes.IDENTIFIER != value) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                this.builder.error("expected offset option value");
                return false;
            }
            PsiBuilder.Marker mark = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            mark.done(AngularJSElementTypes.MESSAGE_FORMAT_OPTION);
        }
        return true;
    }

    private void parseOptionsTail() {
        boolean key = true;
        while (!this.builder.eof()) {
            IElementType type = this.builder.getTokenType();
            if (key) {
                if (JSTokenTypes.RBRACE == type) {
                    this.expectDoubleRBrace(false);
                    return;
                }
                if (JSTokenTypes.LBRACE == type) {
                    this.builder.error("expected selection keyword");
                    return;
                }
                PsiBuilder.Marker mark = this.builder.mark();
                while (!JSTokenTypes.PARSER_WHITE_SPACE_TOKENS.contains(this.builder.rawLookup(0)) && this.builder.rawLookup(0) != null) {
                    this.builder.advanceLexer();
                }
                mark.collapse(AngularJSElementTypes.MESSAGE_FORMAT_SELECTION_KEYWORD);
                key = false;
                continue;
            }
            if (JSTokenTypes.LBRACE == type) {
                this.builder.advanceLexer();
                if (!this.parseInnerMessage()) {
                    return;
                }
                key = true;
                continue;
            }
            this.builder.error("expected message in {} delimiters");
            return;
        }
    }

    private void collapseTokenElement(IElementType type) {
        PsiBuilder.Marker mark = this.builder.mark();
        this.builder.advanceLexer();
        mark.collapse(type);
    }

    private static boolean isKnownExtension(String text) {
        return ExtensionType.select.name().equals(text) || ExtensionType.plural.name().equals(text);
    }

    private static boolean rollback(PsiBuilder.Marker expr) {
        expr.rollbackTo();
        return false;
    }

    public static enum ExtensionType {
        plural(AngularJSPluralCategories.other.name()),
        select("other");

        private final Set<String> myRequiredSelectionKeywords;

        private ExtensionType(String ... keywords) {
            if (keywords.length == 0) {
                this.myRequiredSelectionKeywords = null;
            } else {
                this.myRequiredSelectionKeywords = new HashSet<String>();
                Collections.addAll(this.myRequiredSelectionKeywords, keywords);
            }
        }

        @NotNull
        public Set<String> getRequiredSelectionKeywords() {
            Set<Object> set = this.myRequiredSelectionKeywords == null ? Collections.emptySet() : this.myRequiredSelectionKeywords;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/lang/parser/AngularJSMessageFormatParser$ExtensionType", "getRequiredSelectionKeywords"));
            }
            return set;
        }
    }
}

