/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.angularjs.lang.parser.AngularJSElementTypes;
import org.angularjs.lang.parser.AngularJSMessageFormatParser;
import org.angularjs.lang.psi.AngularJSElementVisitor;
import org.jetbrains.annotations.NotNull;

public class AngularJSMessageFormatExpression
extends JSExpressionImpl {
    private static final Logger LOG = Logger.getInstance((String)"#org.angularjs.lang.psi.AngularJSMessageFormatExpression");

    public AngularJSMessageFormatExpression(ASTNode node) {
        super(node);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/angularjs/lang/psi/AngularJSMessageFormatExpression", "accept"));
        }
        if (visitor instanceof AngularJSElementVisitor) {
            ((AngularJSElementVisitor)visitor).visitMessageFormatExpression(this);
        } else {
            super.accept(visitor);
        }
    }

    public AngularJSMessageFormatParser.ExtensionType getExtensionType() {
        final Ref ref = new Ref();
        PsiTreeUtil.processElements((PsiElement)this, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/lang/psi/AngularJSMessageFormatExpression$1", "execute"));
                }
                boolean isExpressionName = element.getNode().getElementType() == AngularJSElementTypes.MESSAGE_FORMAT_EXPRESSION_NAME;
                ref.set((Object)element);
                return !isExpressionName;
            }
        });
        PsiElement typeElement = this.getExtensionTypeElement();
        if (typeElement == null) {
            return null;
        }
        try {
            return AngularJSMessageFormatParser.ExtensionType.valueOf(typeElement.getText());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public PsiElement getExtensionTypeElement() {
        final Ref ref = new Ref();
        PsiTreeUtil.processElements((PsiElement)this, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/lang/psi/AngularJSMessageFormatExpression$2", "execute"));
                }
                boolean isExpressionName = element.getNode().getElementType() == AngularJSElementTypes.MESSAGE_FORMAT_EXPRESSION_NAME;
                ref.set((Object)element);
                return !isExpressionName;
            }
        });
        if (ref.isNull()) {
            LOG.error("AngularJS message format expression does not have name");
            return null;
        }
        return (PsiElement)ref.get();
    }

    public PsiElement[] getOptions() {
        return ((CompositeElement)this.getNode()).getChildrenAsPsiElements(AngularJSElementTypes.MESSAGE_FORMAT_OPTION, PsiElement.ARRAY_FACTORY);
    }

    public List<PsiElement> getSelectionKeywordElements() {
        if (!(this.getNode() instanceof CompositeElement)) {
            return Collections.emptyList();
        }
        Object[] selectionsKeywords = ((CompositeElement)this.getNode()).getChildrenAsPsiElements(AngularJSElementTypes.MESSAGE_FORMAT_SELECTION_KEYWORD, PsiElement.ARRAY_FACTORY);
        return ContainerUtil.filter((Object[])selectionsKeywords, element -> element.getNode().getElementType() == AngularJSElementTypes.MESSAGE_FORMAT_SELECTION_KEYWORD);
    }
}

