/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.refactoring;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.IncorrectOperationException;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.index.AngularJS2IndexingHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSDirectiveRenameProcessor
extends JSDefaultRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/refactoring/AngularJSDirectiveRenameProcessor", "canProcessElement"));
        }
        return DirectiveUtil.getDirective(element) != null;
    }

    @Nullable
    public PsiElement substituteElementToRename(PsiElement element, @Nullable Editor editor) {
        return DirectiveUtil.getDirective(element);
    }

    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        boolean isAngular2 = DirectiveUtil.isAngular2Directive(element);
        PsiNamedElement directive = (PsiNamedElement)element;
        if (isAngular2 && directive.getName() != null && directive.getName().startsWith("[")) {
            newName = "[" + newName + "]";
        }
        String attributeName = isAngular2 ? newName : DirectiveUtil.getAttributeName(newName);
        for (UsageInfo usage : usages) {
            RenameUtil.rename((UsageInfo)usage, (String)attributeName);
        }
        if (isAngular2) {
            JSExpression value;
            JSProperty selector = AngularJS2IndexingHandler.getSelector(element.getParent());
            JSExpression jSExpression = value = selector != null ? selector.getValue() : null;
            if (value != null) {
                ElementManipulators.getManipulator((PsiElement)value).handleContentChange((PsiElement)value, newName);
            }
        } else {
            directive.setName(DirectiveUtil.attributeToDirective(element, newName));
        }
        if (listener != null) {
            listener.elementRenamed(element);
        }
    }

    public RenameDialog createRenameDialog(Project project, PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        final String directiveName = DirectiveUtil.attributeToDirective(element, ((PsiNamedElement)element).getName());
        return new RenameDialog(project, element, nameSuggestionContext, editor){

            public String[] getSuggestedNames() {
                return new String[]{directiveName};
            }

            protected boolean areButtonsValid() {
                return true;
            }
        };
    }

    public static class AngularJSDirectiveElementDescriptor
    implements ElementDescriptionProvider {
        @Nullable
        public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/refactoring/AngularJSDirectiveRenameProcessor$AngularJSDirectiveElementDescriptor", "getElementDescription"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/angularjs/refactoring/AngularJSDirectiveRenameProcessor$AngularJSDirectiveElementDescriptor", "getElementDescription"));
            }
            JSImplicitElement directive = DirectiveUtil.getDirective(element);
            if (directive != null) {
                if (location instanceof UsageViewTypeLocation) {
                    return "directive";
                }
                return DirectiveUtil.attributeToDirective((PsiElement)directive, directive.getName());
            }
            return null;
        }
    }
}

