/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.service;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPassFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import java.util.Arrays;
import java.util.Optional;
import org.angularjs.service.Angular2LanguageServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2HighlightingPassFactory
extends JSLanguageServiceHighlightingPassFactory {
    @Nullable
    private final Angular2LanguageServiceProvider myProvider;

    public Angular2HighlightingPassFactory(Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        if (highlightingPassRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingPassRegistrar", "org/angularjs/service/Angular2HighlightingPassFactory", "<init>"));
        }
        super(project, highlightingPassRegistrar);
        Optional<JSLanguageServiceProvider> providerOptional = Arrays.stream(JSLanguageServiceProvider.getProviders((Project)project)).filter(el -> el instanceof Angular2LanguageServiceProvider).findAny();
        this.myProvider = providerOptional.isPresent() ? (Angular2LanguageServiceProvider)providerOptional.get() : null;
    }

    @Nullable
    protected JSLanguageService getService() {
        return this.myProvider != null ? this.myProvider.getService() : null;
    }

    protected boolean isAcceptablePsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/service/Angular2HighlightingPassFactory", "isAcceptablePsiFile"));
        }
        if (!super.isAcceptablePsiFile(file) && !(file instanceof HtmlFileImpl)) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && virtualFile.isInLocalFileSystem();
    }
}

