/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.rebase.GitRebaseDialog;
import git4idea.rebase.GitRebaseUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GitRebase
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/actions/GitRebase", "update"));
        }
        super.update(e);
        Project project = e.getProject();
        if (project == null || !GitUtil.hasGitRepositories(project)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(GitRebaseUtils.getRebasingRepositories(project).size() < GitUtil.getRepositories(project).size());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/actions/GitRebase", "actionPerformed"));
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ArrayList repositories = ContainerUtil.newArrayList(GitUtil.getRepositories(project));
        repositories.removeAll(GitRebaseUtils.getRebasingRepositories(project));
        ArrayList roots = ContainerUtil.newArrayList(GitUtil.getRootsFromRepositories(DvcsUtil.sortRepositories((Collection)repositories)));
        VirtualFile defaultRoot = DvcsUtil.guessVcsRoot((Project)project, (VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)));
        final GitRebaseDialog dialog = new GitRebaseDialog(project, roots, defaultRoot);
        if (dialog.showAndGet()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Rebasing..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitRebase$1", "run"));
                    }
                    GitRebaseUtils.rebase(project, Collections.singletonList(dialog.getSelectedRepository()), dialog.getSelectedParams(), indicator);
                }
            });
        }
    }
}

