/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import git4idea.ui.GitRepositoryComboboxListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GitBranchIsNotFullyMergedDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitBranchIsNotFullyMergedDialog.class);
    private final Project myProject;
    private final Map<GitRepository, List<GitCommit>> myCommits;
    private final GitCommitListWithDiffPanel myCommitListWithDiffPanel;
    private final Collection<GitRepository> myRepositories;
    @NotNull
    private final String myRemovedBranch;
    @NotNull
    private final Map<GitRepository, String> myBaseBranches;
    private final GitRepository myInitialRepository;

    public static boolean showAndGetAnswer(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        if (baseBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranches", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        if (removedBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBranch", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "showAndGetAnswer"));
        }
        GitBranchIsNotFullyMergedDialog dialog = new GitBranchIsNotFullyMergedDialog(project, commits, baseBranches, removedBranch);
        DialogManager.show(dialog);
        return dialog.isOK();
    }

    private GitBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        if (baseBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranches", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        if (removedBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBranch", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.myCommits = commits;
        this.myRepositories = commits.keySet();
        this.myBaseBranches = baseBranches;
        this.myRemovedBranch = removedBranch;
        this.myInitialRepository = this.calcInitiallySelectedRepository();
        this.myCommitListWithDiffPanel = new GitCommitListWithDiffPanel(this.myProject, new ArrayList<GitCommit>((Collection)this.myCommits.get(this.myInitialRepository)));
        this.init();
        this.setTitle("Branch Was Not Fully Merged");
        this.setOKButtonText("Restore");
        this.setOKButtonMnemonic(82);
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
    }

    @NotNull
    private GitRepository calcInitiallySelectedRepository() {
        for (GitRepository repository : this.myRepositories) {
            if (this.myCommits.get(repository).isEmpty()) continue;
            GitRepository gitRepository = repository;
            if (gitRepository == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "calcInitiallySelectedRepository"));
            }
            return gitRepository;
        }
        throw new AssertionError((Object)("The dialog shouldn't be shown. Unmerged commits: " + this.myCommits));
    }

    @NotNull
    private String makeDescription(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "makeDescription"));
        }
        String baseBranch = this.myBaseBranches.get(repository);
        String description = baseBranch == null ? String.format("All commits from branch %s were merged", this.myRemovedBranch) : String.format("The branch %s was not fully merged to %s.<br/>Below is the list of unmerged commits.", this.myRemovedBranch, baseBranch);
        String string = XmlStringUtil.wrapInHtml((CharSequence)description);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "makeDescription"));
        }
        return string;
    }

    protected JComponent createNorthPanel() {
        final JBLabel descriptionLabel = new JBLabel(this.makeDescription(this.myInitialRepository));
        final JComboBox<Object> repositorySelector = new JComboBox<Object>(ArrayUtil.toObjectArray(this.myRepositories, GitRepository.class));
        repositorySelector.setRenderer((ListCellRenderer<Object>)((Object)new GitRepositoryComboboxListCellRenderer(repositorySelector)));
        repositorySelector.setSelectedItem(this.myInitialRepository);
        repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRepository selectedRepo = (GitRepository)repositorySelector.getSelectedItem();
                descriptionLabel.setText(GitBranchIsNotFullyMergedDialog.this.makeDescription(selectedRepo));
                GitBranchIsNotFullyMergedDialog.this.myCommitListWithDiffPanel.setCommits((List)GitBranchIsNotFullyMergedDialog.this.myCommits.get(selectedRepo));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("Repository: ");
        label.setLabelFor((Component)repoSelectorPanel);
        repoSelectorPanel.add((Component)label, "West");
        repoSelectorPanel.add(repositorySelector);
        if (this.myRepositories.size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)descriptionLabel);
        northPanel.add((Component)repoSelectorPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add(this.myCommitListWithDiffPanel);
        return rootPanel;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchIsNotFullyMergedDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitListWithDiffPanel.getPreferredFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return GitBranchIsNotFullyMergedDialog.class.getName();
    }
}

