/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProcessEventListener;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeaWideProxySelector;
import com.intellij.vcs.VcsLocaleHelper;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthService;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitSSHGUIHandler;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitXmlRpcSshService;

public abstract class GitHandler {
    protected static final Logger LOG = Logger.getInstance(GitHandler.class);
    protected static final Logger OUTPUT_LOG = Logger.getInstance((String)("#output." + GitHandler.class.getName()));
    private static final Logger TIME_LOG = Logger.getInstance((String)("#time." + GitHandler.class.getName()));
    protected final Project myProject;
    protected final GitCommand myCommand;
    private final HashSet<Integer> myIgnoredErrorCodes;
    private final List<VcsException> myErrors;
    private final List<String> myLastOutput;
    private final int LAST_OUTPUT_SIZE = 5;
    final GeneralCommandLine myCommandLine;
    Process myProcess;
    private boolean myStdoutSuppressed;
    private boolean myStderrSuppressed;
    private final File myWorkingDirectory;
    private UUID mySshHandler;
    private boolean myEnvironmentCleanedUp;
    private UUID myHttpHandler;
    private Processor<OutputStream> myInputProcessor;
    private boolean myIsCancellable;
    private Integer myExitCode;
    @NonNls
    @NotNull
    private Charset myCharset;
    private final EventDispatcher<ProcessEventListener> myListeners;
    protected boolean mySilent;
    protected final GitVcs myVcs;
    private final Map<String, String> myEnv;
    private GitVcsApplicationSettings myAppSettings;
    private GitVcsSettings myProjectSettings;
    private long myStartTime;
    private static final long LONG_TIME = 10000L;
    @Nullable
    private Collection<String> myUrls;
    private boolean myHttpAuthFailed;

    protected GitHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitHandler", "<init>"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "git4idea/commands/GitHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "git4idea/commands/GitHandler", "<init>"));
        }
        if (configParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configParameters", "git4idea/commands/GitHandler", "<init>"));
        }
        this.myIgnoredErrorCodes = new HashSet();
        this.myErrors = Collections.synchronizedList(new ArrayList());
        this.myLastOutput = Collections.synchronizedList(new ArrayList());
        this.LAST_OUTPUT_SIZE = 5;
        this.myEnvironmentCleanedUp = true;
        this.myIsCancellable = true;
        this.myCharset = CharsetToolkit.UTF8_CHARSET;
        this.myListeners = EventDispatcher.create(ProcessEventListener.class);
        this.myProject = project;
        this.myCommand = command;
        this.myAppSettings = GitVcsApplicationSettings.getInstance();
        this.myProjectSettings = GitVcsSettings.getInstance(this.myProject);
        this.myEnv = new HashMap<String, String>(EnvironmentUtil.getEnvironmentMap());
        this.myVcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        this.myWorkingDirectory = directory;
        this.myCommandLine = new GeneralCommandLine();
        if (this.myAppSettings != null) {
            this.myCommandLine.setExePath(this.myAppSettings.getPathToGit());
        }
        this.myCommandLine.setWorkDirectory(this.myWorkingDirectory);
        if (GitVersionSpecialty.CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND.existsIn(this.myVcs.getVersion())) {
            this.myCommandLine.addParameters(new String[]{"-c", "core.quotepath=false"});
            for (String configParameter : configParameters) {
                this.myCommandLine.addParameters(new String[]{"-c", configParameter});
            }
        }
        this.myCommandLine.addParameter(command.name());
        this.myStdoutSuppressed = true;
        this.mySilent = this.myCommand.lockingPolicy() == GitCommand.LockingPolicy.READ;
    }

    protected GitHandler(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/commands/GitHandler", "<init>"));
        }
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "git4idea/commands/GitHandler", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "git4idea/commands/GitHandler", "<init>"));
        }
        if (configParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configParameters", "git4idea/commands/GitHandler", "<init>"));
        }
        this(project, VfsUtil.virtualToIoFile((VirtualFile)vcsRoot), command, configParameters);
    }

    protected ProcessEventListener listeners() {
        return (ProcessEventListener)this.myListeners.getMulticaster();
    }

    public void ignoreErrorCode(int code) {
        this.myIgnoredErrorCodes.add(code);
    }

    public boolean isIgnoredErrorCode(int code) {
        return this.myIgnoredErrorCodes.contains(code);
    }

    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }

    public void addLastOutput(String line) {
        if (this.myLastOutput.size() < 5) {
            this.myLastOutput.add(line);
        } else {
            this.myLastOutput.add(0, line);
            Collections.rotate(this.myLastOutput, -1);
        }
    }

    public List<String> getLastOutput() {
        return this.myLastOutput;
    }

    public List<VcsException> errors() {
        return Collections.unmodifiableList(this.myErrors);
    }

    public Project project() {
        return this.myProject;
    }

    public File workingDirectory() {
        return this.myWorkingDirectory;
    }

    public VirtualFile workingDirectoryFile() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(this.workingDirectory());
        if (file == null) {
            throw new IllegalStateException("The working directly should be available: " + this.workingDirectory());
        }
        return file;
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/commands/GitHandler", "setUrl"));
        }
        this.setUrls(Collections.singletonList(url));
    }

    public void setUrls(@NotNull Collection<String> urls) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "git4idea/commands/GitHandler", "setUrls"));
        }
        this.myUrls = urls;
    }

    protected boolean isRemote() {
        return this.myUrls != null;
    }

    protected void addListener(ProcessEventListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void endOptions() {
        this.myCommandLine.addParameter("--");
    }

    public void addParameters(String ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/commands/GitHandler", "addParameters"));
        }
        this.addParameters(Arrays.asList(parameters));
    }

    public void addParameters(List<String> parameters) {
        this.checkNotStarted();
        for (String parameter : parameters) {
            this.myCommandLine.addParameter(this.escapeParameterIfNeeded(parameter));
        }
    }

    @NotNull
    private String escapeParameterIfNeeded(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "git4idea/commands/GitHandler", "escapeParameterIfNeeded"));
        }
        if (this.escapeNeeded(parameter)) {
            String string = parameter.replaceAll("\\^", "^^^^");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "escapeParameterIfNeeded"));
            }
            return string;
        }
        String string = parameter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "escapeParameterIfNeeded"));
        }
        return string;
    }

    private boolean escapeNeeded(@NotNull String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "git4idea/commands/GitHandler", "escapeNeeded"));
        }
        return SystemInfo.isWindows && this.isCmd() && parameter.contains("^");
    }

    private boolean isCmd() {
        return this.myAppSettings.getPathToGit().toLowerCase().endsWith("cmd");
    }

    @NotNull
    private String unescapeCommandLine(@NotNull String commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "git4idea/commands/GitHandler", "unescapeCommandLine"));
        }
        if (this.escapeNeeded(commandLine)) {
            String string = commandLine.replaceAll("\\^\\^\\^\\^", "^");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "unescapeCommandLine"));
            }
            return string;
        }
        String string = commandLine;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "unescapeCommandLine"));
        }
        return string;
    }

    public void addRelativePaths(FilePath ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/commands/GitHandler", "addRelativePaths"));
        }
        this.addRelativePaths(Arrays.asList(parameters));
    }

    public void addRelativePaths(@NotNull Collection<FilePath> filePaths) {
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "git4idea/commands/GitHandler", "addRelativePaths"));
        }
        this.checkNotStarted();
        for (FilePath path : filePaths) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.myWorkingDirectory, (FilePath)path));
        }
    }

    public void addRelativeFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/commands/GitHandler", "addRelativeFiles"));
        }
        this.checkNotStarted();
        for (VirtualFile file : files) {
            this.myCommandLine.addParameter(VcsFileUtil.relativePath((File)this.myWorkingDirectory, (VirtualFile)file));
        }
    }

    public boolean addProgressParameter() {
        if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(this.myVcs.getVersion())) {
            this.addParameters("--progress");
            return true;
        }
        return false;
    }

    private void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("The process has been already started");
        }
    }

    protected final void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("The process is not started yet");
        }
    }

    public final synchronized boolean isStarted() {
        return this.myProcess != null;
    }

    public void setCancellable(boolean value) {
        this.checkNotStarted();
        this.myIsCancellable = value;
    }

    public boolean isCancellable() {
        return this.myIsCancellable;
    }

    public synchronized void start() {
        this.checkNotStarted();
        try {
            this.myStartTime = System.currentTimeMillis();
            if (!this.myProject.isDefault() && !this.mySilent && this.myVcs != null) {
                this.myVcs.showCommandLine("[" + this.stringifyWorkingDir() + "] " + this.printableCommandLine());
                LOG.info("[" + this.stringifyWorkingDir() + "] " + this.printableCommandLine());
            } else {
                LOG.debug("[" + this.stringifyWorkingDir() + "] " + this.printableCommandLine());
            }
            if (this.isRemote()) {
                this.setupHttpAuthenticator();
                if (this.myProjectSettings.isIdeaSsh()) {
                    this.setupSshAuthenticator();
                }
            }
            this.setUpLocale();
            this.unsetGitTrace();
            this.myCommandLine.getEnvironment().clear();
            this.myCommandLine.getEnvironment().putAll(this.myEnv);
            this.myProcess = this.startProcess();
            this.startHandlingStreams();
        }
        catch (ProcessCanceledException pce) {
            this.cleanupEnv();
        }
        catch (Throwable t) {
            if (!ApplicationManager.getApplication().isUnitTestMode() || !this.myProject.isDisposed()) {
                LOG.error(t);
            }
            this.cleanupEnv();
            ((ProcessEventListener)this.myListeners.getMulticaster()).startFailed(t);
        }
    }

    private void setUpLocale() {
        this.myEnv.putAll(VcsLocaleHelper.getDefaultLocaleEnvironmentVars((String)"git"));
    }

    private void unsetGitTrace() {
        this.myEnv.put("GIT_TRACE", "0");
    }

    private void setupHttpAuthenticator() throws IOException {
        GitHttpAuthService service = (GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class);
        this.myEnv.put("GIT_ASKPASS", service.getScriptPath().getPath());
        GitHttpAuthenticator httpAuthenticator = service.createAuthenticator(this.myProject, this.myCommand, (Collection)ObjectUtils.assertNotNull(this.myUrls));
        this.myHttpHandler = service.registerHandler(httpAuthenticator, (Disposable)this.myProject);
        this.myEnvironmentCleanedUp = false;
        this.myEnv.put("GIT_ASKPASS_HANDLER", this.myHttpHandler.toString());
        int port = service.getXmlRcpPort();
        this.myEnv.put("GIT_ASKPASS_PORT", Integer.toString(port));
        LOG.debug(String.format("handler=%s, port=%s", this.myHttpHandler, port));
        this.addAuthListener(httpAuthenticator);
    }

    private void setupSshAuthenticator() throws IOException {
        GitXmlRpcSshService ssh = (GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class);
        this.myEnv.put("GIT_SSH", ssh.getScriptPath().getPath());
        this.mySshHandler = ssh.registerHandler(new GitSSHGUIHandler(this.myProject), (Disposable)this.myProject);
        this.myEnvironmentCleanedUp = false;
        this.myEnv.put("GIT4IDEA_SSH_HANDLER", this.mySshHandler.toString());
        int port = ssh.getXmlRcpPort();
        this.myEnv.put("GIT4IDEA_SSH_PORT", Integer.toString(port));
        LOG.debug(String.format("handler=%s, port=%s", this.mySshHandler, port));
        HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
        boolean useHttpProxy = httpConfigurable.USE_HTTP_PROXY && !GitHandler.isSshUrlExcluded(httpConfigurable, (Collection)ObjectUtils.assertNotNull(this.myUrls));
        this.myEnv.put("GIT4IDEA_SSH_USE_PROXY", String.valueOf(useHttpProxy));
        if (useHttpProxy) {
            this.myEnv.put("GIT4IDEA_SSH_PROXY_HOST", StringUtil.notNullize((String)httpConfigurable.PROXY_HOST));
            this.myEnv.put("GIT4IDEA_SSH_PROXY_PORT", String.valueOf(httpConfigurable.PROXY_PORT));
            boolean proxyAuthentication = httpConfigurable.PROXY_AUTHENTICATION;
            this.myEnv.put("GIT4IDEA_SSH_PROXY_AUTHENTICATION", String.valueOf(proxyAuthentication));
            if (proxyAuthentication) {
                this.myEnv.put("GIT4IDEA_SSH_PROXY_USER", StringUtil.notNullize((String)httpConfigurable.getProxyLogin()));
                this.myEnv.put("GIT4IDEA_SSH_PROXY_PASSWORD", StringUtil.notNullize((String)httpConfigurable.getPlainProxyPassword()));
            }
        }
    }

    protected static boolean isSshUrlExcluded(final @NotNull HttpConfigurable httpConfigurable, @NotNull Collection<String> urls) {
        if (httpConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "httpConfigurable", "git4idea/commands/GitHandler", "isSshUrlExcluded"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "git4idea/commands/GitHandler", "isSshUrlExcluded"));
        }
        return ContainerUtil.exists(urls, (Condition)new Condition<String>(){

            public boolean value(String url) {
                String host = URLUtil.parseHostFromSshUrl((String)url);
                return ((IdeaWideProxySelector)httpConfigurable.getOnlyBySettingsSelector()).isProxyException(host);
            }
        });
    }

    private void addAuthListener(final @NotNull GitHttpAuthenticator authenticator) {
        if (authenticator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authenticator", "git4idea/commands/GitHandler", "addAuthListener"));
        }
        if (this instanceof GitLineHandler) {
            ((GitLineHandler)this).addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(@NonNls String line, Key outputType) {
                    String lowerCaseLine = line.toLowerCase();
                    if (lowerCaseLine.contains("authentication failed") || lowerCaseLine.contains("403 forbidden")) {
                        LOG.debug("auth listener: auth failure detected: " + line);
                        GitHandler.this.myHttpAuthFailed = true;
                    }
                }

                @Override
                public void processTerminated(int exitCode) {
                    LOG.debug("auth listener: process terminated. auth failed=" + GitHandler.this.myHttpAuthFailed + ", cancelled=" + authenticator.wasCancelled());
                    if (!authenticator.wasCancelled()) {
                        if (GitHandler.this.myHttpAuthFailed) {
                            authenticator.forgetPassword();
                        } else {
                            authenticator.saveAuthData();
                        }
                    } else {
                        GitHandler.this.myHttpAuthFailed = false;
                    }
                }
            });
        }
    }

    public boolean hasHttpAuthFailed() {
        return this.myHttpAuthFailed;
    }

    protected abstract Process startProcess() throws ExecutionException;

    protected abstract void startHandlingStreams();

    public String printableCommandLine() {
        return this.unescapeCommandLine(this.myCommandLine.getCommandLineString("git"));
    }

    public synchronized void cancel() {
        this.checkStarted();
        if (!this.myIsCancellable) {
            throw new IllegalStateException("The process is not cancellable.");
        }
        this.destroyProcess();
    }

    public abstract void destroyProcess();

    public synchronized int getExitCode() {
        if (this.myExitCode == null) {
            throw new IllegalStateException("Exit code is not yet available");
        }
        return this.myExitCode;
    }

    protected synchronized void setExitCode(int exitCode) {
        if (this.myExitCode == null) {
            this.myExitCode = exitCode;
        } else {
            LOG.info("Not setting exit code " + exitCode + ", because it was already set to " + this.myExitCode);
        }
    }

    protected synchronized void cleanupEnv() {
        if (this.myEnvironmentCleanedUp) {
            return;
        }
        if (this.mySshHandler != null) {
            ((GitXmlRpcSshService)ServiceManager.getService(GitXmlRpcSshService.class)).unregisterHandler(this.mySshHandler);
        }
        if (this.myHttpHandler != null) {
            ((GitHttpAuthService)ServiceManager.getService(GitHttpAuthService.class)).unregisterHandler(this.myHttpHandler);
        }
        this.myEnvironmentCleanedUp = true;
    }

    public void waitFor() {
        this.checkStarted();
        try {
            if (this.myInputProcessor != null && this.myProcess != null) {
                this.myInputProcessor.process((Object)this.myProcess.getOutputStream());
            }
        }
        finally {
            this.waitForProcess();
        }
    }

    protected abstract void waitForProcess();

    public void setSilent(boolean silent) {
        this.checkNotStarted();
        this.mySilent = silent;
        if (silent) {
            this.setStderrSuppressed(true);
            this.setStdoutSuppressed(true);
        }
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "getCharset"));
        }
        return charset;
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "git4idea/commands/GitHandler", "setCharset"));
        }
        this.myCharset = charset;
    }

    public boolean isStdoutSuppressed() {
        return this.myStdoutSuppressed;
    }

    public void setStdoutSuppressed(boolean stdoutSuppressed) {
        this.checkNotStarted();
        this.myStdoutSuppressed = stdoutSuppressed;
    }

    public boolean isStderrSuppressed() {
        return this.myStderrSuppressed;
    }

    public void setStderrSuppressed(boolean stderrSuppressed) {
        this.checkNotStarted();
        this.myStderrSuppressed = stderrSuppressed;
    }

    public void setEnvironment(String name, String value) {
        this.myEnv.put(name, value);
    }

    public boolean isLargeCommandLine() {
        return this.myCommandLine.getCommandLineString().length() > 7600;
    }

    public void runInCurrentThread(@Nullable Runnable postStartAction) {
        GitVcs vcs = GitVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        if (GitCommand.LockingPolicy.WRITE == this.myCommand.lockingPolicy()) {
            vcs.getCommandLock().writeLock().lock();
        }
        try {
            this.start();
            if (this.isStarted()) {
                if (postStartAction != null) {
                    postStartAction.run();
                }
                this.waitFor();
            }
        }
        finally {
            if (GitCommand.LockingPolicy.WRITE == this.myCommand.lockingPolicy()) {
                vcs.getCommandLock().writeLock().unlock();
            }
            this.logTime();
        }
    }

    @NotNull
    private String stringifyWorkingDir() {
        String basePath = this.myProject.getBasePath();
        if (basePath != null) {
            String relPath = FileUtil.getRelativePath((String)basePath, (String)FileUtil.toSystemIndependentName((String)this.myWorkingDirectory.getPath()), (char)'/');
            if (".".equals(relPath)) {
                String string = this.myWorkingDirectory.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "stringifyWorkingDir"));
                }
                return string;
            }
            if (relPath != null) {
                String string = FileUtil.toSystemDependentName((String)relPath);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "stringifyWorkingDir"));
                }
                return string;
            }
        }
        String string = this.myWorkingDirectory.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitHandler", "stringifyWorkingDir"));
        }
        return string;
    }

    private void logTime() {
        if (this.myStartTime > 0L) {
            long time = System.currentTimeMillis() - this.myStartTime;
            if (!TIME_LOG.isDebugEnabled() && time > 10000L) {
                LOG.info(String.format("git %s took %s ms. Command parameters: %n%s", this.myCommand, time, this.myCommandLine.getCommandLineString()));
            } else {
                TIME_LOG.debug(String.format("git %s took %s ms", this.myCommand, time));
            }
        } else {
            LOG.debug(String.format("git %s finished.", this.myCommand));
        }
    }

    public String toString() {
        return this.myCommandLine.toString();
    }
}

