/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitLineHandlerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMessageWithFilesDetector
implements GitLineHandlerListener {
    private static final Logger LOG = Logger.getInstance(GitMessageWithFilesDetector.class);
    @NotNull
    private final Event myEvent;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    protected final Set<String> myAffectedFiles;
    protected boolean myMessageDetected;
    @Nullable
    private Key myMessageOutputType;

    public GitMessageWithFilesDetector(@NotNull Event event, @NotNull VirtualFile root) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/commands/GitMessageWithFilesDetector", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/commands/GitMessageWithFilesDetector", "<init>"));
        }
        this.myAffectedFiles = new HashSet<String>();
        this.myEvent = event;
        this.myRoot = root;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "git4idea/commands/GitMessageWithFilesDetector", "onLineAvailable"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "git4idea/commands/GitMessageWithFilesDetector", "onLineAvailable"));
        }
        if (line.contains(this.myEvent.messageStartMarker)) {
            LOG.debug("|" + this.myEvent.name + "| message start marker detected in [" + line + "]of type " + outputType);
            this.myMessageDetected = true;
            this.myMessageOutputType = outputType;
        } else if (line.contains(this.myEvent.messageEndMarker)) {
            LOG.debug("|" + this.myEvent.name + "| message end marker detected in [" + line + "]of type " + outputType);
            this.myMessageOutputType = null;
        } else if (outputType.equals((Object)this.myMessageOutputType)) {
            LOG.debug("|" + this.myEvent.name + "| Treating as a file: [" + line + "]of type " + outputType);
            this.myAffectedFiles.add(line.trim());
        } else {
            LOG.debug("|" + this.myEvent.name + "| Plain message: [" + line + "]of type " + outputType);
        }
    }

    public void processTerminated(int exitCode) {
    }

    public void startFailed(Throwable exception) {
    }

    public boolean wasMessageDetected() {
        return this.myMessageDetected;
    }

    @NotNull
    public Set<String> getRelativeFilePaths() {
        Set<String> set = this.myAffectedFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitMessageWithFilesDetector", "getRelativeFilePaths"));
        }
        return set;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myAffectedFiles.size());
        for (String affectedFile : this.myAffectedFiles) {
            VirtualFile file = this.myRoot.findFileByRelativePath(FileUtil.toSystemIndependentName((String)affectedFile));
            if (file == null) continue;
            files.add(file);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/commands/GitMessageWithFilesDetector", "getFiles"));
        }
        return arrayList;
    }

    public static class Event {
        @NotNull
        private final String name;
        @NotNull
        private final String messageStartMarker;
        @NotNull
        private final String messageEndMarker;

        Event(@NotNull String eventName, @NotNull String messageStartMarker, @NotNull String messageEndMarker) {
            if (eventName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventName", "git4idea/commands/GitMessageWithFilesDetector$Event", "<init>"));
            }
            if (messageStartMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageStartMarker", "git4idea/commands/GitMessageWithFilesDetector$Event", "<init>"));
            }
            if (messageEndMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageEndMarker", "git4idea/commands/GitMessageWithFilesDetector$Event", "<init>"));
            }
            this.name = eventName;
            this.messageStartMarker = messageStartMarker;
            this.messageEndMarker = messageEndMarker;
        }
    }
}

