/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitProgressAnalyzer;
import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectDoubleProcedure;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GitStandardProgressAnalyzer
implements GitProgressAnalyzer {
    private TObjectDoubleHashMap<Operation> myOperationsProgress = new TObjectDoubleHashMap(4);

    public static GitLineHandlerListener createListener(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/commands/GitStandardProgressAnalyzer", "createListener"));
        }
        final GitStandardProgressAnalyzer progressAnalyzer = new GitStandardProgressAnalyzer();
        return new GitLineHandlerAdapter(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                double fraction = progressAnalyzer.analyzeProgress(line);
                if (fraction >= 0.0) {
                    indicator.setFraction(fraction);
                }
            }
        };
    }

    @Override
    public double analyzeProgress(String output) {
        for (Operation operation : Operation.values()) {
            Matcher matcher = operation.myPattern.matcher(output);
            if (!matcher.matches()) continue;
            try {
                double operationProgress = operation.getProgress(Integer.parseInt(matcher.group(1)));
                this.myOperationsProgress.put((Object)operation, operationProgress);
            }
            catch (NumberFormatException e) {
                return -1.0;
            }
            return this.updateTotalProgress(operation);
        }
        return -1.0;
    }

    private double updateTotalProgress(Operation currentOperation) {
        for (Operation op : Operation.values()) {
            if (currentOperation.compareTo(op) <= 0) continue;
            this.myOperationsProgress.put((Object)op, 1.0);
        }
        final double[] totalProgress = new double[1];
        this.myOperationsProgress.forEachEntry((TObjectDoubleProcedure)new TObjectDoubleProcedure<Operation>(){

            public boolean execute(Operation operation, double progress) {
                totalProgress[0] = totalProgress[0] + operation.myFractionInTotal * progress;
                return true;
            }
        });
        return totalProgress[0];
    }

    private static enum Operation {
        COUNTING_OBJECTS(".*Counting objects: +(\\d+).*", 0.05){

            @Override
            double getProgress(int outputNumber) {
                if (outputNumber > 5000) {
                    return 1.0;
                }
                return (double)outputNumber / 5000.0;
            }
        }
        ,
        COMPRESSING_OBJECTS(".*Compressing objects: +(\\d{1,3})%.*", 0.1),
        RECEIVING_OR_WRITING_OBJECTS(".*(?:Receiving|Writing) objects: +(\\d{1,3})%.*", 0.8),
        RESOLVING_DELTAS(".*Resolving deltas: +(\\d{1,3})%.*", 0.05);

        private Pattern myPattern;
        private double myFractionInTotal;

        private Operation(String pattern, double fractionInTotal) {
            this.myPattern = Pattern.compile(pattern, 2);
            this.myFractionInTotal = fractionInTotal;
        }

        double getProgress(int outputNumber) {
            return (double)outputNumber / 100.0;
        }
    }
}

