/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.BranchStorage;
import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.repo.Repository;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchType;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchManager {
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    public final BranchStorage myPredefinedFavoriteBranches;

    public GitBranchManager(@NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings settings) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/ui/branch/GitBranchManager", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/ui/branch/GitBranchManager", "<init>"));
        }
        this.myPredefinedFavoriteBranches = new BranchStorage();
        this.myRepositoryManager = repositoryManager;
        this.mySettings = settings;
        for (GitBranchType type : GitBranchType.values()) {
            this.myPredefinedFavoriteBranches.myBranches.put(type.toString(), this.constructDefaultBranchPredefinedList(type));
        }
    }

    @NotNull
    private List<DvcsBranchInfo> constructDefaultBranchPredefinedList(GitBranchType type) {
        ArrayList branchInfos = ContainerUtil.newArrayList((Object[])new DvcsBranchInfo[]{new DvcsBranchInfo("", GitBranchManager.getDefaultBranchName(type))});
        branchInfos.addAll(ContainerUtil.map2List(this.myRepositoryManager.getRepositories(), repository -> new DvcsBranchInfo(repository.getRoot().getPath(), GitBranchManager.getDefaultBranchName(type))));
        ArrayList arrayList = branchInfos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchManager", "constructDefaultBranchPredefinedList"));
        }
        return arrayList;
    }

    @NotNull
    private static String getDefaultBranchName(@NotNull GitBranchType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "git4idea/ui/branch/GitBranchManager", "getDefaultBranchName"));
        }
        String string = type == GitBranchType.LOCAL ? "master" : "origin/master";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchManager", "getDefaultBranchName"));
        }
        return string;
    }

    public boolean isFavorite(@NotNull GitBranchType branchType, @Nullable GitRepository repository, @NotNull String branchName) {
        if (branchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchType", "git4idea/ui/branch/GitBranchManager", "isFavorite"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchManager", "isFavorite"));
        }
        if (this.mySettings.isFavorite(branchType, repository, branchName)) {
            return true;
        }
        if (this.mySettings.isExcludedFromFavorites(branchType, repository, branchName)) {
            return false;
        }
        return this.myPredefinedFavoriteBranches.contains(branchType.toString(), (Repository)repository, branchName);
    }

    public void setFavorite(@NotNull GitBranchType branchType, @Nullable GitRepository repository, @NotNull String branchName, boolean shouldBeFavorite) {
        if (branchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchType", "git4idea/ui/branch/GitBranchManager", "setFavorite"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/ui/branch/GitBranchManager", "setFavorite"));
        }
        if (shouldBeFavorite) {
            this.mySettings.addToFavorites(branchType, repository, branchName);
            this.mySettings.removeFromExcluded(branchType, repository, branchName);
        } else if (this.mySettings.isFavorite(branchType, repository, branchName)) {
            this.mySettings.removeFromFavorites(branchType, repository, branchName);
        } else if (this.myPredefinedFavoriteBranches.contains(branchType.toString(), (Repository)repository, branchName)) {
            this.mySettings.excludedFromFavorites(branchType, repository, branchName);
        }
    }
}

