/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ignore.FileIterationListener;

public class IgnoreGroupHelperAction {
    private boolean myAllCanBeIgnored;
    private boolean myAllAreIgnored;
    private FileIterationListener myListener;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "update"));
        }
        this.myAllAreIgnored = true;
        this.myAllCanBeIgnored = true;
        Project project = e.getProject();
        SvnVcs vcs = project != null ? SvnVcs.getInstance(project) : null;
        Object[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        boolean visible = project != null;
        e.getPresentation().setEnabled(visible && vcs != null && !ArrayUtil.isEmpty((Object[])files) && this.isEnabled(vcs, (VirtualFile[])files));
        e.getPresentation().setVisible(visible);
    }

    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "isEnabled"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "isEnabled"));
        }
        return ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).checkAllFilesAreUnder((AbstractVcs)vcs, files) && Stream.of(files).allMatch(file -> {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "lambda$isEnabled$0"));
            }
            return this.isEnabled(vcs, (VirtualFile)file);
        });
    }

    public void setFileIterationListener(FileIterationListener listener) {
        this.myListener = listener;
    }

    private boolean isEnabledImpl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VirtualFile parent;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "isEnabledImpl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "isEnabledImpl"));
        }
        if (SvnStatusUtil.isIgnoredInAnySense(vcs.getProject(), file)) {
            this.myAllCanBeIgnored = false;
            return this.myAllAreIgnored;
        }
        if (ChangeListManager.getInstance((Project)vcs.getProject()).isUnversioned(file) && (parent = file.getParent()) != null && SvnStatusUtil.isUnderControl(vcs, parent)) {
            this.myAllAreIgnored = false;
            return this.myAllCanBeIgnored;
        }
        this.myAllCanBeIgnored = false;
        this.myAllAreIgnored = false;
        return false;
    }

    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/ignore/IgnoreGroupHelperAction", "isEnabled"));
        }
        boolean result = this.isEnabledImpl(vcs, file);
        if (result) {
            this.myListener.onFileEnabled(file);
        }
        return result;
    }

    public boolean allCanBeIgnored() {
        return this.myAllCanBeIgnored;
    }

    public boolean allAreIgnored() {
        return this.myAllAreIgnored;
    }
}

