/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SmallMapSerializer;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.CopyData;
import org.jetbrains.idea.svn.history.FirstInBranch;
import org.tmatesoft.svn.core.SVNURL;

public class SvnBranchPointsCalculator {
    private static final Logger LOG = Logger.getInstance(SvnBranchPointsCalculator.class);
    @NotNull
    private final SmallMapSerializer<String, TreeMap<String, BranchCopyData>> myPersistentMap;
    @NotNull
    private final Object myPersistenceLock;
    @NotNull
    private final SvnVcs myVcs;

    public SvnBranchPointsCalculator(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "<init>"));
        }
        this.myPersistenceLock = new Object();
        this.myVcs = vcs;
        File directory = new File(new File(PathManager.getSystemPath(), "vcs"), "svn_copy_sources");
        directory.mkdirs();
        File file = new File(directory, this.myVcs.getProject().getLocationHash());
        this.myPersistentMap = new SmallMapSerializer(file, EnumeratorStringDescriptor.INSTANCE, new BranchDataExternalizer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WrapperInvertor getBestHit(@NotNull String repoUrl, @NotNull String sourceUrl, @NotNull String targetUrl) {
        if (repoUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "getBestHit"));
        }
        if (sourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "getBestHit"));
        }
        if (targetUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "getBestHit"));
        }
        Object object = this.myPersistenceLock;
        synchronized (object) {
            WrapperInvertor result = null;
            TreeMap<String, BranchCopyData> map = this.myPersistentMap.get(repoUrl);
            if (map != null) {
                BranchCopyData sourceData = SvnBranchPointsCalculator.getBranchData(map, sourceUrl);
                BranchCopyData targetData = SvnBranchPointsCalculator.getBranchData(map, targetUrl);
                if (sourceData != null && targetData != null) {
                    boolean inverted = sourceData.getTargetRevision() > targetData.getTargetRevision();
                    result = new WrapperInvertor(inverted, inverted ? sourceData : targetData);
                } else if (sourceData != null) {
                    result = new WrapperInvertor(true, sourceData);
                } else if (targetData != null) {
                    result = new WrapperInvertor(false, targetData);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.myPersistenceLock;
        synchronized (object) {
            this.myPersistentMap.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist(@NotNull String repoUrl, @NotNull BranchCopyData data) {
        if (repoUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "persist"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "persist"));
        }
        Object object = this.myPersistenceLock;
        synchronized (object) {
            TreeMap map = this.myPersistentMap.get(repoUrl);
            if (map == null) {
                map = ContainerUtil.newTreeMap();
            }
            map.put(data.getTarget(), data);
            this.myPersistentMap.put(repoUrl, map);
            this.myPersistentMap.force();
        }
    }

    @Nullable
    private static BranchCopyData getBranchData(@NotNull NavigableMap<String, BranchCopyData> map, @NotNull String url) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "getBranchData"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "getBranchData"));
        }
        Map.Entry<String, BranchCopyData> branchData = map.floorEntry(url);
        return branchData != null && url.startsWith(branchData.getKey()) ? branchData.getValue() : null;
    }

    @Nullable
    public WrapperInvertor calculateCopyPoint(@NotNull SVNURL repoUrl, @NotNull String sourceUrl, @NotNull String targetUrl) throws VcsException {
        CopyData copyData;
        if (repoUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "calculateCopyPoint"));
        }
        if (sourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "calculateCopyPoint"));
        }
        if (targetUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "calculateCopyPoint"));
        }
        WrapperInvertor result = this.getBestHit(repoUrl.toDecodedString(), sourceUrl, targetUrl);
        if (result == null && (copyData = new FirstInBranch(this.myVcs, repoUrl, targetUrl, sourceUrl).run()) != null) {
            BranchCopyData branchCopyData = copyData.isTrunkSupposedCorrect() ? new BranchCopyData(sourceUrl, copyData.getCopySourceRevision(), targetUrl, copyData.getCopyTargetRevision()) : new BranchCopyData(targetUrl, copyData.getCopySourceRevision(), sourceUrl, copyData.getCopyTargetRevision());
            this.persist(repoUrl.toDecodedString(), branchCopyData);
            result = new WrapperInvertor(!copyData.isTrunkSupposedCorrect(), branchCopyData);
        }
        SvnBranchPointsCalculator.logCopyData(repoUrl.toDecodedString(), sourceUrl, targetUrl, result);
        return result;
    }

    private static void logCopyData(@NotNull String repoUrl, @NotNull String sourceUrl, @NotNull String targetUrl, @Nullable WrapperInvertor inverter) {
        if (repoUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "logCopyData"));
        }
        if (sourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "logCopyData"));
        }
        if (targetUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetUrl", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator", "logCopyData"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("repoURL: " + repoUrl + ", sourceUrl:" + sourceUrl + ", targetUrl: " + targetUrl + ", inverter: " + inverter);
        }
    }

    public static class BranchCopyData {
        private final String mySource;
        private final String myTarget;
        private final long mySourceRevision;
        private final long myTargetRevision;

        public BranchCopyData(String source, long sourceRevision, String target, long targetRevision) {
            this.mySource = source;
            this.mySourceRevision = sourceRevision;
            this.myTarget = target;
            this.myTargetRevision = targetRevision;
        }

        public String toString() {
            return "source: " + this.mySource + "@" + this.mySourceRevision + " target: " + this.myTarget + "@" + this.myTargetRevision;
        }

        public String getSource() {
            return this.mySource;
        }

        public long getSourceRevision() {
            return this.mySourceRevision;
        }

        public String getTarget() {
            return this.myTarget;
        }

        public long getTargetRevision() {
            return this.myTargetRevision;
        }

        public BranchCopyData invertSelf() {
            return new BranchCopyData(this.myTarget, this.myTargetRevision, this.mySource, this.mySourceRevision);
        }
    }

    public static class WrapperInvertor {
        private final BranchCopyData myWrapped;
        private final boolean myInvertedSense;

        public WrapperInvertor(boolean invertedSense, BranchCopyData wrapped) {
            this.myInvertedSense = invertedSense;
            this.myWrapped = wrapped;
        }

        public boolean isInvertedSense() {
            return this.myInvertedSense;
        }

        public BranchCopyData getWrapped() {
            return this.myWrapped;
        }

        public BranchCopyData getTrue() {
            return this.myInvertedSense ? this.myWrapped.invertSelf() : this.myWrapped;
        }

        public BranchCopyData inverted() {
            return this.myWrapped.invertSelf();
        }

        public String toString() {
            return "inverted: " + this.myInvertedSense + " wrapped: " + this.myWrapped.toString();
        }
    }

    private static class BranchDataExternalizer
    implements DataExternalizer<TreeMap<String, BranchCopyData>> {
        private BranchDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull TreeMap<String, BranchCopyData> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "save"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "save"));
            }
            out.writeInt(value.size());
            for (Map.Entry<String, BranchCopyData> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                BranchDataExternalizer.save(out, entry.getValue());
            }
        }

        private static void save(@NotNull DataOutput out, @NotNull BranchCopyData value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "save"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "save"));
            }
            out.writeUTF(value.getSource());
            out.writeUTF(value.getTarget());
            out.writeLong(value.getSourceRevision());
            out.writeLong(value.getTargetRevision());
        }

        @NotNull
        public TreeMap<String, BranchCopyData> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "read"));
            }
            TreeMap result = ContainerUtil.newTreeMap();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result.put(in.readUTF(), BranchDataExternalizer.readCopyPoint(in));
            }
            TreeMap treeMap = result;
            if (treeMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "read"));
            }
            return treeMap;
        }

        @NotNull
        private static BranchCopyData readCopyPoint(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "readCopyPoint"));
            }
            String sourceUrl = in.readUTF();
            String targetUrl = in.readUTF();
            long sourceRevision = in.readLong();
            long targetRevision = in.readLong();
            BranchCopyData branchCopyData = new BranchCopyData(sourceUrl, sourceRevision, targetUrl, targetRevision);
            if (branchCopyData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/SvnBranchPointsCalculator$BranchDataExternalizer", "readCopyPoint"));
            }
            return branchCopyData;
        }
    }
}

