/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.actions.BackgroundTaskGroup;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.treeConflict.ApplyPatchSaveToFileExecutor;
import org.jetbrains.idea.svn.treeConflict.SvnTreeConflictResolver;
import org.jetbrains.idea.svn.treeConflict.TreeConflictRefreshablePanel;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class MergeFromTheirsResolver
extends BackgroundTaskGroup {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final TreeConflictDescription myDescription;
    @NotNull
    private final Change myChange;
    @NotNull
    private final FilePath myOldFilePath;
    @NotNull
    private final FilePath myNewFilePath;
    @NotNull
    private final String myOldPresentation;
    @NotNull
    private final String myNewPresentation;
    private final SvnRevisionNumber myCommittedRevision;
    private Boolean myAdd;
    @NotNull
    private final List<Change> myTheirsChanges;
    @NotNull
    private final List<Change> myTheirsBinaryChanges;
    private List<TextFilePatch> myTextPatches;
    private final VirtualFile myBaseForPatch;
    private boolean myThereAreCreations;

    public MergeFromTheirsResolver(@NotNull SvnVcs vcs, @NotNull TreeConflictDescription description, @NotNull Change change, SvnRevisionNumber revision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "<init>"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "<init>"));
        }
        super(vcs.getProject(), "Resolve tree conflict");
        this.myVcs = vcs;
        this.myDescription = description;
        this.myChange = change;
        this.myCommittedRevision = revision;
        this.myOldFilePath = ((ContentRevision)ObjectUtils.notNull((Object)this.myChange.getBeforeRevision())).getFile();
        this.myNewFilePath = ((ContentRevision)ObjectUtils.notNull((Object)this.myChange.getAfterRevision())).getFile();
        this.myBaseForPatch = ChangesUtil.findValidParentAccurately((FilePath)this.myNewFilePath);
        this.myOldPresentation = TreeConflictRefreshablePanel.filePath(this.myOldFilePath);
        this.myNewPresentation = TreeConflictRefreshablePanel.filePath(this.myNewFilePath);
        this.myTheirsChanges = ContainerUtilRt.newArrayList();
        this.myTheirsBinaryChanges = ContainerUtilRt.newArrayList();
        this.myTextPatches = Collections.emptyList();
    }

    public void execute() {
        String messageKey = this.myChange.isMoved() ? "confirmation.resolve.tree.conflict.merge.moved" : "confirmation.resolve.tree.conflict.merge.renamed";
        String message = SvnBundle.message(messageKey, this.myOldPresentation, this.myNewPresentation);
        int ok = Messages.showOkCancelDialog((Project)this.myVcs.getProject(), (String)message, (String)"Resolve tree conflict", (Icon)Messages.getQuestionIcon());
        if (0 != ok) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        this.runInBackground("Getting base and theirs revisions content", indicator -> this.preloadContent());
        this.runInEdt(this::convertTextPaths);
        this.runInBackground("Creating patch for theirs changes", indicator -> this.createPatches());
        this.runInEdt(() -> this.selectPatchesInApplyPatchDialog((Consumer<VcsException>)((Consumer)exception -> {
            if (exception == null) {
                this.runInBackground("Accepting working state", indicator -> this.resolveConflicts());
                if (this.myThereAreCreations) {
                    this.runInBackground("Adding " + this.myOldPresentation + " to Subversion", indicator -> this.addDirectories());
                }
                this.runInEdt(this::selectBinaryFiles);
                this.runInBackground("Applying binary changes", indicator -> this.applyBinaryChanges());
                this.runInEdt(this::notifyMergeIsFinished);
            } else {
                this.addError((VcsException)((Object)((Object)exception)));
                this.showErrors();
            }
        })));
    }

    private void notifyMergeIsFinished() {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myVcs.getProject(), (String)("Theirs changes merged for " + this.myOldPresentation), (MessageType)MessageType.INFO, (NamedRunnable[])new NamedRunnable[0]);
        this.showErrors();
    }

    private void resolveConflicts() throws VcsException {
        new SvnTreeConflictResolver(this.myVcs, this.myOldFilePath, null).resolveSelectMineFull();
    }

    private void convertTextPaths() throws VcsException {
        List<Change> convertedChanges = this.convertPaths(this.myTheirsChanges);
        this.myTheirsChanges.clear();
        this.myTheirsChanges.addAll(convertedChanges);
    }

    private void selectPatchesInApplyPatchDialog(@NotNull Consumer<VcsException> callback) throws VcsException {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "selectPatchesInApplyPatchDialog"));
        }
        LocalChangeList changeList = ChangeListManager.getInstance((Project)this.myVcs.getProject()).getChangeList(this.myChange);
        TreeConflictApplyTheirsPatchExecutor patchExecutor = new TreeConflictApplyTheirsPatchExecutor(this.myVcs, this.myBaseForPatch);
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(this.myVcs.getProject(), (ApplyPatchExecutor)patchExecutor, Collections.singletonList(new ApplyPatchSaveToFileExecutor(this.myVcs.getProject(), this.myBaseForPatch)), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, this.myTextPatches, changeList);
        patchExecutor.myPromise.done(callback);
        dialog.show();
    }

    private void addDirectories() throws VcsException {
        this.myVcs.getFactory(this.myOldFilePath.getIOFile()).createAddClient().add(this.myOldFilePath.getIOFile(), Depth.EMPTY, true, false, true, null);
    }

    private void createPatches() throws VcsException {
        List patches = IdeaTextPatchBuilder.buildPatch((Project)this.myVcs.getProject(), this.myTheirsChanges, (String)((VirtualFile)ObjectUtils.notNull((Object)this.myBaseForPatch)).getPath(), (boolean)false);
        this.myTextPatches = ContainerUtil.map((Collection)patches, TextFilePatch.class::cast);
    }

    private void selectBinaryFiles() throws VcsException {
        List<Change> converted = this.convertPaths(this.myTheirsBinaryChanges);
        if (!converted.isEmpty()) {
            Map map = converted.stream().collect(Collectors.toMap(ChangesUtil::getFilePath, Function.identity()));
            Collection<FilePath> selected = this.chooseBinaryFiles(converted, map.keySet());
            this.myTheirsBinaryChanges.clear();
            if (!ContainerUtil.isEmpty(selected)) {
                for (FilePath filePath : selected) {
                    this.myTheirsBinaryChanges.add((Change)map.get(filePath));
                }
            }
        }
    }

    private void applyBinaryChanges() throws VcsException {
        final ArrayList dirtyPaths = ContainerUtilRt.newArrayList();
        for (final Change change : this.myTheirsBinaryChanges) {
            RunResult result = new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$1", "run"));
                    }
                    dirtyPaths.add(ChangesUtil.getFilePath((Change)change));
                    try {
                        MergeFromTheirsResolver.applyBinaryChange(change);
                    }
                    catch (IOException e) {
                        throw new VcsException((Throwable)e);
                    }
                }
            }.execute();
            if (!result.hasException()) continue;
            this.processBinaryChangeError(result.getThrowable());
        }
        VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).filePathsDirty((Collection)dirtyPaths, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBinaryChangeError(@NotNull Throwable error) throws VcsException {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "processBinaryChangeError"));
        }
        if (error instanceof VcsException) {
            VcsException vcsError = (VcsException)error;
            if (!vcsError.isWarning()) throw vcsError;
            this.addError(vcsError);
            return;
        } else {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)error);
        }
    }

    private static void applyBinaryChange(@NotNull Change change) throws IOException, VcsException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "applyBinaryChange"));
        }
        if (change.getAfterRevision() == null) {
            FilePath path = ((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getFile();
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path.getPath());
            if (file == null) {
                throw new VcsException("Can not delete file: " + path.getPath(), true);
            }
            file.delete(TreeConflictRefreshablePanel.class);
        } else {
            FilePath file = change.getAfterRevision().getFile();
            String parentPath = ((FilePath)ObjectUtils.notNull((Object)file.getParentPath())).getPath();
            VirtualFile parentFile = VfsUtil.createDirectoryIfMissing((String)parentPath);
            if (parentFile == null) {
                throw new VcsException("Can not create directory: " + parentPath, true);
            }
            VirtualFile child = parentFile.createChildData(TreeConflictRefreshablePanel.class, file.getName());
            byte[] content = ((BinaryContentRevision)change.getAfterRevision()).getBinaryContent();
            if (content == null) {
                throw new VcsException("Can not load Theirs content for file " + file.getPath(), true);
            }
            child.setBinaryContent(content);
        }
    }

    @Nullable
    private Collection<FilePath> chooseBinaryFiles(@NotNull List<Change> changes, @NotNull Set<FilePath> paths) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "chooseBinaryFiles"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "chooseBinaryFiles"));
        }
        String singleMessage = "";
        if (changes.size() == 1) {
            FileStatus status = changes.get(0).getFileStatus();
            FilePath path = ChangesUtil.getFilePath((Change)changes.get(0));
            String prefix = FileStatus.DELETED.equals(status) ? "Delete" : (FileStatus.ADDED.equals(status) ? "Create" : "Apply changes to");
            singleMessage = prefix + "binary file " + TreeConflictRefreshablePanel.filePath(path) + " (according to theirs changes)?";
        }
        return AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).selectFilePathsToProcess((List)ContainerUtilRt.newArrayList(paths), "Resolve tree conflict", "Select binary files to patch", "Resolve tree conflict", singleMessage, new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return null;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
            }

            public boolean isPersistent() {
                return false;
            }
        });
    }

    @NotNull
    private List<Change> convertPaths(@NotNull List<Change> changes) throws VcsException {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "convertPaths"));
        }
        this.initAddOption();
        ArrayList result = ContainerUtilRt.newArrayList();
        for (Change change : changes) {
            if (!MergeFromTheirsResolver.isUnderOldDir(change, this.myOldFilePath)) continue;
            result.add(new Change(this.convertBeforeRevision(change.getBeforeRevision()), this.convertAfterRevision(change, change.getAfterRevision())));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "convertPaths"));
        }
        return arrayList;
    }

    @Nullable
    private ContentRevision convertBeforeRevision(@Nullable ContentRevision revision) throws VcsException {
        return revision != null ? this.toSimpleRevision(revision, true) : null;
    }

    @Nullable
    private ContentRevision convertAfterRevision(@NotNull Change change, @Nullable ContentRevision revision) throws VcsException {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "convertAfterRevision"));
        }
        if (revision == null) {
            return null;
        }
        return this.myAdd != false && (change.getBeforeRevision() == null || change.isMoved() || change.isRenamed()) ? revision : this.toSimpleRevision(revision, true);
    }

    @NotNull
    private SimpleContentRevision toSimpleRevision(@NotNull ContentRevision revision, boolean rebasePath) throws VcsException {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "toSimpleRevision"));
        }
        SimpleContentRevision simpleContentRevision = new SimpleContentRevision(revision.getContent(), rebasePath ? MergeFromTheirsResolver.rebasePath(this.myOldFilePath, this.myNewFilePath, revision.getFile()) : this.myNewFilePath, revision.getRevisionNumber().asString());
        if (simpleContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "toSimpleRevision"));
        }
        return simpleContentRevision;
    }

    private static boolean isUnderOldDir(@NotNull Change change, @NotNull FilePath path) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "isUnderOldDir"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "isUnderOldDir"));
        }
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        return beforePath != null && FileUtil.isAncestor((String)path.getPath(), (String)beforePath.getPath(), (boolean)true) || afterPath != null && FileUtil.isAncestor((String)path.getPath(), (String)afterPath.getPath(), (boolean)true);
    }

    @NotNull
    private static FilePath rebasePath(@NotNull FilePath oldBase, @NotNull FilePath newBase, @NotNull FilePath path) {
        if (oldBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldBase", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        if (newBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newBase", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        String relativePath = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)oldBase.getPath(), (String)path.getPath(), (char)'/'));
        FilePath filePath = VcsUtil.getFilePath((String)(newBase.getPath() + "/" + relativePath), (boolean)path.isDirectory());
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "rebasePath"));
        }
        return filePath;
    }

    private void preloadContent() throws VcsException {
        if (this.myDescription.isDirectory()) {
            this.preloadForDirectory();
        } else {
            this.preloadForFile();
        }
    }

    private void preloadForFile() throws VcsException {
        SvnContentRevision base = SvnContentRevision.createBaseRevision(this.myVcs, this.myNewFilePath, this.myCommittedRevision.getRevision());
        SvnContentRevision remote = SvnContentRevision.createRemote(this.myVcs, this.myOldFilePath, SVNRevision.create((long)this.myDescription.getSourceRightVersion().getPegRevision()));
        this.myTheirsChanges.add(new Change((ContentRevision)this.toSimpleRevision(base, false), (ContentRevision)this.toSimpleRevision(remote, false)));
    }

    private void preloadForDirectory() throws VcsException {
        List changes = CommittedChangesTreeBrowser.collectChanges(this.loadSvnChangeListsForPatch(this.myDescription), (boolean)true);
        for (Change change : changes) {
            MergeFromTheirsResolver.preloadRevisionContents(change.getBeforeRevision());
            MergeFromTheirsResolver.preloadRevisionContents(change.getAfterRevision());
        }
        Map<Boolean, List<Change>> changesSplit = changes.stream().collect(Collectors.partitioningBy(ChangesUtil::isBinaryChange));
        this.myTheirsBinaryChanges.addAll((Collection<Change>)changesSplit.get(Boolean.TRUE));
        this.myTheirsChanges.addAll((Collection<Change>)changesSplit.get(Boolean.FALSE));
    }

    private static void preloadRevisionContents(@Nullable ContentRevision revision) throws VcsException {
        if (revision != null) {
            if (revision instanceof BinaryContentRevision) {
                ((BinaryContentRevision)revision).getBinaryContent();
            } else {
                revision.getContent();
            }
        }
    }

    @NotNull
    private List<SvnChangeList> loadSvnChangeListsForPatch(@NotNull TreeConflictDescription description) throws VcsException {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "loadSvnChangeListsForPatch"));
        }
        long max = description.getSourceRightVersion().getPegRevision();
        long min = description.getSourceLeftVersion().getPegRevision();
        SvnRepositoryLocation location = new SvnRepositoryLocation(description.getSourceRightVersion().getRepositoryRoot().toString());
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = String.valueOf(max);
        settings.CHANGE_AFTER = String.valueOf(min);
        List committedChanges = ((CachingCommittedChangesProvider)ObjectUtils.notNull((Object)this.myVcs.getCachingCommittedChangesProvider())).getCommittedChanges(settings, (RepositoryLocation)location, 0);
        List list = ContainerUtil.filter((Collection)committedChanges, changeList -> changeList.getNumber() != min);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "loadSvnChangeListsForPatch"));
        }
        return list;
    }

    private void initAddOption() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAdd == null) {
            this.myAdd = this.getAddedFilesPlaceOption();
        }
    }

    private boolean getAddedFilesPlaceOption() {
        final SvnConfiguration configuration = this.myVcs.getSvnConfiguration();
        Boolean add = configuration.isKeepNewFilesAsIsForTreeConflictMerge();
        if (add != null) {
            return add;
        }
        if (!MergeFromTheirsResolver.containAdditions(this.myTheirsChanges) && !MergeFromTheirsResolver.containAdditions(this.myTheirsBinaryChanges)) {
            return false;
        }
        return 0 == ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Resolve tree conflict", (String)"Keep newly created file(s) in their original place?").yesText("Keep")).noText("Move")).doNotAsk(new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    configuration.setKeepNewFilesAsIsForTreeConflictMerge(exitCode == 0);
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$3", "getDoNotShowMessage"));
                }
                return string;
            }
        })).show();
    }

    private static boolean containAdditions(@NotNull List<Change> changes) {
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver", "containAdditions"));
        }
        return changes.stream().anyMatch(change -> change.getBeforeRevision() == null || change.isMoved() || change.isRenamed());
    }

    private class TreeConflictApplyTheirsPatchExecutor
    implements ApplyPatchExecutor<TextFilePatchInProgress> {
        @NotNull
        private final SvnVcs myVcs;
        private final VirtualFile myBaseDir;
        @NotNull
        private final AsyncPromise<VcsException> myPromise;

        public TreeConflictApplyTheirsPatchExecutor(SvnVcs vcs, VirtualFile baseDir) {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "<init>"));
            }
            this.myVcs = vcs;
            this.myBaseDir = baseDir;
            this.myPromise = new AsyncPromise();
        }

        public String getName() {
            return "Apply Patch";
        }

        public void apply(@NotNull List<FilePatch> remaining, @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
            if (remaining == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remaining", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "apply"));
            }
            if (patchGroupsToApply == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchGroupsToApply", "org/jetbrains/idea/svn/treeConflict/MergeFromTheirsResolver$TreeConflictApplyTheirsPatchExecutor", "apply"));
            }
            List<FilePatch> patches = null;
            VcsException exception = null;
            try {
                patches = ApplyPatchSaveToFileExecutor.toOnePatchGroup(patchGroupsToApply, this.myBaseDir);
            }
            catch (IOException e) {
                exception = new VcsException((Throwable)e);
            }
            if (patches != null) {
                new PatchApplier(this.myVcs.getProject(), this.myBaseDir, patches, localList, null, null).execute(false, true);
                MergeFromTheirsResolver.this.myThereAreCreations = patches.stream().anyMatch(patch -> patch.isNewFile() || !Comparing.equal((String)patch.getAfterName(), (String)patch.getBeforeName()));
            }
            this.myPromise.setResult((Object)exception);
        }
    }
}

