/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdateSessionAdapter;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWCRootCrawler;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.update.AbstractUpdateIntegrateCrawler;
import org.jetbrains.idea.svn.update.SvnUpdateContext;
import org.jetbrains.idea.svn.update.UpdateEventHandler;

public abstract class AbstractSvnUpdateIntegrateEnvironment
implements UpdateEnvironment {
    protected final SvnVcs myVcs;
    private final ProjectLevelVcsManager myVcsManager;
    @NonNls
    public static final String REPLACED_ID = "replaced";

    protected AbstractSvnUpdateIntegrateEnvironment(SvnVcs vcs) {
        this.myVcs = vcs;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)vcs.getProject());
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
        updatedFiles.registerGroup(new FileGroup(VcsBundle.message((String)"update.group.name.merged.with.property.conflicts", (Object[])new Object[0]), VcsBundle.message((String)"status.group.name.will.be.merged.with.property.conflicts", (Object[])new Object[0]), false, "MERGED_WITH_PROPERTY_CONFLICT", false));
        updatedFiles.registerGroup(new FileGroup(VcsBundle.message((String)"update.group.name.merged.with.tree.conflicts", (Object[])new Object[0]), VcsBundle.message((String)"status.group.name.will.be.merged.with.tree.conflicts", (Object[])new Object[0]), false, "MERGED_WITH_TREE_CONFLICT", false));
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] contentRoots, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> context) throws ProcessCanceledException {
        if (contentRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "org/jetbrains/idea/svn/update/AbstractSvnUpdateIntegrateEnvironment", "updateDirectories"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/update/AbstractSvnUpdateIntegrateEnvironment", "updateDirectories"));
        }
        if (context.isNull()) {
            context.set((Object)new SvnUpdateContext(this.myVcs, contentRoots));
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        UpdateEventHandler eventHandler = new UpdateEventHandler(this.myVcs, progressIndicator, (SvnUpdateContext)context.get());
        eventHandler.setUpdatedFiles(updatedFiles);
        boolean totalUpdate = true;
        AbstractUpdateIntegrateCrawler crawler = this.createCrawler(eventHandler, totalUpdate, exceptions, updatedFiles);
        HashSet<VirtualFile> updatedRoots = new HashSet<VirtualFile>();
        Arrays.sort(contentRoots, new Comparator<FilePath>(){

            @Override
            public int compare(FilePath o1, FilePath o2) {
                return SystemInfo.isFileSystemCaseSensitive ? o1.getPath().replace("/", "\\").compareTo(o2.getPath().replace("/", "\\")) : o1.getPath().replace("/", "\\").compareToIgnoreCase(o2.getPath().replace("/", "\\"));
            }
        });
        for (FilePath contentRoot : contentRoots) {
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            File ioRoot = contentRoot.getIOFile();
            if (!((SvnUpdateContext)context.get()).shouldRunFor(ioRoot)) continue;
            updatedRoots.addAll(SvnUtil.crawlWCRoots(this.myVcs, ioRoot, (SvnWCRootCrawler)crawler, progressIndicator));
        }
        if (updatedRoots.isEmpty()) {
            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getProject(), (String)SvnBundle.message("message.text.update.no.directories.found", new Object[0]), (String)SvnBundle.message("messate.text.update.error", new Object[0]));
                }
            }, null, (Project)this.myVcs.getProject());
            UpdateSessionAdapter updateSessionAdapter = new UpdateSessionAdapter(Collections.emptyList(), true);
            if (updateSessionAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/update/AbstractSvnUpdateIntegrateEnvironment", "updateDirectories"));
            }
            return updateSessionAdapter;
        }
        MyUpdateSessionAdapter myUpdateSessionAdapter = new MyUpdateSessionAdapter(contentRoots, updatedFiles, exceptions);
        if (myUpdateSessionAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/update/AbstractSvnUpdateIntegrateEnvironment", "updateDirectories"));
        }
        return myUpdateSessionAdapter;
    }

    protected boolean isDryRun() {
        return false;
    }

    protected abstract AbstractUpdateIntegrateCrawler createCrawler(UpdateEventHandler var1, boolean var2, ArrayList<VcsException> var3, UpdatedFiles var4);

    @Nullable
    public abstract Configurable createConfigurable(Collection<FilePath> var1);

    private class MyUpdateSessionAdapter
    extends UpdateSessionAdapter {
        private final FilePath[] myContentRoots;
        private final UpdatedFiles myUpdatedFiles;
        private final VcsDirtyScopeManager myDirtyScopeManager;
        private final List<Runnable> myGroupWorkers;

        private MyUpdateSessionAdapter(FilePath[] contentRoots, UpdatedFiles updatedFiles, List<VcsException> exceptions) {
            if (contentRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoots", "org/jetbrains/idea/svn/update/AbstractSvnUpdateIntegrateEnvironment$MyUpdateSessionAdapter", "<init>"));
            }
            super(exceptions, false);
            this.myContentRoots = contentRoots;
            this.myUpdatedFiles = updatedFiles;
            this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getProject());
            this.myGroupWorkers = !AbstractSvnUpdateIntegrateEnvironment.this.isDryRun() ? Arrays.asList(new MyTextConflictWorker(), new MyConflictWorker("MERGED_WITH_PROPERTY_CONFLICT"){

                @Override
                protected List<VirtualFile> merge() {
                    return null;
                }
            }, new MyTreeConflictWorker(), new MyReplacedWorker()) : Collections.emptyList();
        }

        private void dirtyRoots() {
            Collection vfColl = Arrays.stream(this.myContentRoots).map(FilePath::getVirtualFile).filter(Objects::nonNull).collect(Collectors.toList());
            this.myDirtyScopeManager.filesDirty(vfColl, null);
        }

        public void onRefreshFilesCompleted() {
            this.dirtyRoots();
            for (Runnable groupWorker : this.myGroupWorkers) {
                groupWorker.run();
            }
        }

        private abstract class MyConflictWorker
        implements Runnable {
            private final String groupId;
            protected final List<VirtualFile> myFiles;
            private final LocalFileSystem myLfs;
            private final ProjectLevelVcsManager myPlVcsManager;

            protected MyConflictWorker(String groupId) {
                this.groupId = groupId;
                this.myFiles = new ArrayList<VirtualFile>();
                this.myLfs = LocalFileSystem.getInstance();
                this.myPlVcsManager = ProjectLevelVcsManager.getInstance((Project)AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getProject());
            }

            protected List<VirtualFile> prepareWritable(Collection<VirtualFile> files) {
                ArrayList<VirtualFile> writable = new ArrayList<VirtualFile>();
                for (VirtualFile vf : files) {
                    if (!AbstractSvnUpdateIntegrateEnvironment.this.myVcs.equals(this.myPlVcsManager.getVcsFor(vf))) continue;
                    writable.add(vf);
                }
                ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getProject()).ensureFilesWritable(writable);
                writable.removeAll(Arrays.asList(operationStatus.getReadonlyFiles()));
                return writable;
            }

            @Nullable
            protected abstract List<VirtualFile> merge();

            @Override
            public void run() {
                List<VirtualFile> merged;
                this.fillAndRefreshFiles();
                if (!this.myFiles.isEmpty() && (merged = this.merge()) != null && !merged.isEmpty()) {
                    this.moveToMergedGroup(merged);
                    MyUpdateSessionAdapter.this.myDirtyScopeManager.filesDirty(merged, null);
                }
            }

            protected void moveToMergedGroup(List<VirtualFile> merged) {
                FileGroup conflictedGroup = MyUpdateSessionAdapter.this.myUpdatedFiles.getGroupById(this.groupId);
                FileGroup mergedGroup = MyUpdateSessionAdapter.this.myUpdatedFiles.getGroupById("MERGED");
                for (VirtualFile mergedFile : merged) {
                    String path = FileUtil.toSystemDependentName((String)mergedFile.getPresentableUrl());
                    VcsRevisionNumber revision = conflictedGroup.getRevision(AbstractSvnUpdateIntegrateEnvironment.this.myVcsManager, path);
                    conflictedGroup.remove(path);
                    mergedGroup.add(path, AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getKeyInstanceMethod(), revision);
                }
            }

            protected void fillAndRefreshFiles() {
                FileGroup conflictedGroup = MyUpdateSessionAdapter.this.myUpdatedFiles.getGroupById(this.groupId);
                Collection conflictedFiles = conflictedGroup.getFiles();
                ArrayList<VirtualFile> parents = new ArrayList<VirtualFile>();
                if (conflictedFiles != null && !conflictedFiles.isEmpty()) {
                    for (String conflictedFile : conflictedFiles) {
                        File file = new File(conflictedFile);
                        VirtualFile vf = this.myLfs.findFileByIoFile(file);
                        if (vf == null) {
                            vf = this.myLfs.refreshAndFindFileByIoFile(file);
                        }
                        if (vf == null) continue;
                        this.myFiles.add(vf);
                        VirtualFile parent = vf.getParent();
                        if (parent == null) continue;
                        parents.add(parent);
                    }
                }
                if (!this.myFiles.isEmpty()) {
                    RefreshQueue.getInstance().refresh(true, true, null, parents);
                    MyUpdateSessionAdapter.this.myDirtyScopeManager.filesDirty(this.myFiles, null);
                }
            }
        }

        private class MyTextConflictWorker
        extends MyConflictWorker {
            private MyTextConflictWorker() {
                super("MERGED_WITH_CONFLICTS");
            }

            @Override
            protected List<VirtualFile> merge() {
                List<VirtualFile> writable = this.prepareWritable(this.myFiles);
                AbstractVcsHelper vcsHelper = AbstractVcsHelper.getInstance((Project)AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getProject());
                return vcsHelper.showMergeDialog(writable, (MergeProvider)new SvnMergeProvider(AbstractSvnUpdateIntegrateEnvironment.this.myVcs.getProject()));
            }
        }

        private class MyTreeConflictWorker
        implements Runnable {
            private MyTreeConflictWorker() {
            }

            @Override
            public void run() {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                FileGroup conflictedGroup = MyUpdateSessionAdapter.this.myUpdatedFiles.getGroupById("MERGED_WITH_TREE_CONFLICT");
                Collection conflictedFiles = conflictedGroup.getFiles();
                final ArrayList<VirtualFile> parents = new ArrayList<VirtualFile>();
                if (conflictedFiles != null && !conflictedFiles.isEmpty()) {
                    for (String conflictedFile : conflictedFiles) {
                        File file = new File(conflictedFile);
                        VirtualFile vfFile = lfs.refreshAndFindFileByIoFile(file);
                        if (vfFile != null) {
                            parents.add(vfFile);
                            continue;
                        }
                        File parent = file.getParentFile();
                        VirtualFile vf = lfs.findFileByIoFile(parent);
                        if (vf == null) {
                            vf = lfs.refreshAndFindFileByIoFile(parent);
                        }
                        if (vf == null) continue;
                        parents.add(vf);
                    }
                }
                if (!parents.isEmpty()) {
                    RefreshQueue.getInstance().refresh(true, true, new Runnable(){

                        @Override
                        public void run() {
                            MyUpdateSessionAdapter.this.myDirtyScopeManager.filesDirty(null, parents);
                        }
                    }, parents);
                }
            }
        }

        private class MyReplacedWorker
        implements Runnable {
            private MyReplacedWorker() {
            }

            @Override
            public void run() {
                FileGroup replacedGroup = MyUpdateSessionAdapter.this.myUpdatedFiles.getGroupById(AbstractSvnUpdateIntegrateEnvironment.REPLACED_ID);
                FileGroup deletedGroup = MyUpdateSessionAdapter.this.myUpdatedFiles.getGroupById("REMOVED_FROM_REPOSITORY");
                if (deletedGroup != null && replacedGroup != null && !deletedGroup.isEmpty() && !replacedGroup.isEmpty()) {
                    HashSet replacedFiles = new HashSet(replacedGroup.getFiles());
                    HashSet deletedFiles = new HashSet(deletedGroup.getFiles());
                    for (String deletedFile : deletedFiles) {
                        if (!replacedFiles.contains(deletedFile)) continue;
                        deletedGroup.remove(deletedFile);
                    }
                }
            }
        }
    }
}

