/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSFlipConditionalIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        FlipConditionalPredicate flipConditionalPredicate = new FlipConditionalPredicate();
        if (flipConditionalPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention", "getElementPredicate"));
        }
        return flipConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention", "processIntention"));
        }
        JSConditionalExpression exp = (JSConditionalExpression)element;
        JSExpression condition = exp.getCondition();
        JSExpression elseExpression = exp.getElse();
        JSExpression thenExpression = exp.getThen();
        assert (elseExpression != null);
        assert (thenExpression != null);
        String newExpression = BoolUtils.getNegatedExpressionText(condition) + '?' + elseExpression.getText() + ':' + thenExpression.getText();
        JSElementFactory.replaceExpression((JSExpression)exp, newExpression);
    }

    private static class FlipConditionalPredicate
    implements JSElementPredicate {
        private FlipConditionalPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention$FlipConditionalPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            if (ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            JSConditionalExpression condition = (JSConditionalExpression)element;
            return condition.getCondition() != null && condition.getThen() != null && condition.getElse() != null;
        }
    }
}

