/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.constant;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ExpressionUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSConstantExpressionIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        ConstantExpressionPredicate constantExpressionPredicate = new ConstantExpressionPredicate();
        if (constantExpressionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention", "getElementPredicate"));
        }
        return constantExpressionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        String newExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention", "processIntention"));
        }
        JSExpression expression = (JSExpression)element;
        Object value = ExpressionUtil.computeConstantExpression(expression);
        if (value instanceof String) {
            boolean shouldUseTemplateString = JSConstantExpressionIntention.shouldUseTemplateString(expression);
            String quote = shouldUseTemplateString ? "`" : JSCodeStyleSettings.getQuote((PsiElement)expression);
            newExpression = quote + value + quote;
        } else {
            newExpression = String.valueOf(value);
        }
        JSElementFactory.replaceExpression(expression, newExpression);
    }

    public static boolean shouldUseTemplateString(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention", "shouldUseTemplateString"));
        }
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)expression);
        if (optionHolder == null || !optionHolder.hasFeature(JSLanguageFeature.STRING_TEMPLATES)) {
            return false;
        }
        Ref result = new Ref();
        PsiTreeUtil.processElements((PsiElement)expression, element -> {
            if (!result.isNull()) {
                return false;
            }
            if (element instanceof JSStringTemplateExpression) {
                result.set((Object)true);
            }
            return true;
        });
        return Boolean.TRUE == result.get();
    }

    private static class ConstantExpressionPredicate
    implements JSElementPredicate {
        private ConstantExpressionPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention$ConstantExpressionPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSExpression)) {
                return false;
            }
            if (ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            JSExpression expression = (JSExpression)element;
            if (element instanceof JSLiteralExpression || element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null || expression instanceof JSCallExpression) {
                return false;
            }
            if (!ExpressionUtil.isConstantExpression(expression)) {
                return false;
            }
            if (ExpressionUtil.computeConstantExpression(expression) == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSExpression)) {
                return true;
            }
            return !ExpressionUtil.isConstantExpression((JSExpression)parent);
        }
    }
}

