/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.parenthesis;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.UnnecessaryParenthesesChecker;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class JSRemoveUnnecessaryParenthesesIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = new JSElementPredicate(){

            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/parenthesis/JSRemoveUnnecessaryParenthesesIntention$1", "satisfiedBy"));
                }
                if (!JSInheritedLanguagesHelper.isRemoveUnnecessaryParenthesesEnabled((PsiElement)element) || ErrorUtil.containsError((PsiElement)element)) {
                    return false;
                }
                if (element instanceof JSParenthesizedExpression) {
                    return UnnecessaryParenthesesChecker.shouldRemove((JSParenthesizedExpression)((JSParenthesizedExpression)element));
                }
                DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)element);
                boolean supportsArrowFunctions = dialectOptionHolder != null && dialectOptionHolder.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS);
                JSParameterList parameterList = element instanceof JSParameterList ? (JSParameterList)element : null;
                JSFunctionExpression arrowFunction = element.getParent() instanceof JSFunctionExpression ? (JSFunctionExpression)element.getParent() : null;
                return supportsArrowFunctions && parameterList != null && parameterList.getParameters().length == 1 && !(parameterList.getParameters()[0] instanceof JSDestructuringParameter) && !parameterList.getParameters()[0].isRest() && JSPsiImplUtils.isArrowFunction((JSFunction)arrowFunction) != null && element.getNode().findChildByType(JSTokenTypes.LPAR) != null && arrowFunction.getReturnTypeElement() == null;
            }
        };
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/parenthesis/JSRemoveUnnecessaryParenthesesIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/parenthesis/JSRemoveUnnecessaryParenthesesIntention", "processIntention"));
        }
        if (element instanceof JSParameterList) {
            JSChangeUtil.replaceElement((JSElement)((JSElement)element), (JSElement)((JSParameterList)element).getParameters()[0]);
            return;
        }
        JSExpression exp = (JSExpression)element;
        while (exp.getParent() instanceof JSExpression) {
            exp = (JSExpression)exp.getParent();
            assert (exp != null);
        }
        String newExpression = ParenthesesUtils.removeParentheses(exp);
        JSElementFactory.replaceExpression(exp, newExpression);
    }
}

