/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static boolean isConstantExpression(JSExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.isConstant;
    }

    public static boolean isIncrementDecrementExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/intellij/idea/lang/javascript/psiutil/ExpressionUtil", "isIncrementDecrementExpression"));
        }
        if (expression instanceof JSPostfixExpression) {
            IElementType operator = ((JSPostfixExpression)expression).getOperationSign();
            return JSTokenTypes.PLUSPLUS.equals(operator) || JSTokenTypes.MINUSMINUS.equals(operator);
        }
        if (expression instanceof JSPrefixExpression) {
            IElementType operator = ((JSPrefixExpression)expression).getOperationSign();
            return JSTokenTypes.PLUSPLUS.equals(operator) || JSTokenTypes.MINUSMINUS.equals(operator);
        }
        return false;
    }

    @Nullable
    public static Object computeConstantExpression(JSExpression expression) {
        if (expression == null) {
            return null;
        }
        JSComputeConstantExpressionVisitor visitor = new JSComputeConstantExpressionVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.getResult();
    }

    public static class JSComputeConstantExpressionVisitor
    extends JSElementVisitor {
        private final Stack<Object> myStack = new Stack();

        @Nullable
        private Object getResult() {
            if (this.myStack.isEmpty()) {
                return null;
            }
            Object res = this.myStack.pop();
            if (res == null) {
                this.myStack.clear();
            }
            return res;
        }

        public void visitJSParenthesizedExpression(JSParenthesizedExpression node) {
            JSExpression innerExpression = node.getInnerExpression();
            if (innerExpression != null) {
                innerExpression.accept((PsiElementVisitor)this);
            }
        }

        public void visitJSLiteralExpression(JSLiteralExpression node) {
            Object value = null;
            String text = node.getText();
            if (node.isNumericLiteral()) {
                value = JSComputeConstantExpressionVisitor.getNumericValue(text);
            } else if (node.isQuotedLiteral()) {
                value = String.valueOf(node.getValue());
            } else {
                boolean equalsWithTrue = "true".equals(text);
                if (equalsWithTrue || "false".equals(text)) {
                    value = equalsWithTrue;
                }
            }
            this.pushValue(value);
        }

        private void pushValue(Object value) {
            double t;
            Double doubleValue;
            if (value instanceof Double && !(doubleValue = (Double)value).isInfinite() && !doubleValue.isNaN() && doubleValue > -9.223372036854776E18 && doubleValue < 9.223372036854776E18 && value.equals(t = Math.ceil(doubleValue))) {
                value = doubleValue.longValue();
            }
            this.myStack.push(value);
        }

        public void visitJSConditionalExpression(JSConditionalExpression node) {
            Object value;
            JSExpression condition = node.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
            }
            if ((value = this.getResult()) == null) {
                return;
            }
            JSExpression expression = JSComputeConstantExpressionVisitor.toBoolean(value) != false ? node.getThen() : node.getElse();
            expression.accept((PsiElementVisitor)this);
        }

        public void visitJSPrefixExpression(JSPrefixExpression node) {
            JSExpression expression = node.getExpression();
            expression.accept((PsiElementVisitor)this);
            Object value = this.getResult();
            if (value == null) {
                return;
            }
            IElementType operationSign = node.getOperationSign();
            Number number = JSComputeConstantExpressionVisitor.toNumber(value);
            if (operationSign == JSTokenTypes.MINUS) {
                value = -number.doubleValue();
            } else if (operationSign == JSTokenTypes.TILDE) {
                value = number.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
            } else if (operationSign == JSTokenTypes.EXCL) {
                value = JSComputeConstantExpressionVisitor.toBoolean(value) == false;
            } else if (operationSign == JSTokenTypes.PLUS) {
                value = number;
            }
            this.pushValue(value);
        }

        public void visitJSPostfixExpression(JSPostfixExpression node) {
            JSExpression expression = node.getExpression();
            expression.accept((PsiElementVisitor)this);
            Object result = this.getResult();
            if (result == null) {
                return;
            }
            Number number = JSComputeConstantExpressionVisitor.toNumber(result);
            Number value = JSComputeConstantExpressionVisitor.computeIncrementDecrementExpression(number, node.getOperationSign());
            this.pushValue(value);
        }

        public void visitJSBinaryExpression(JSBinaryExpression node) {
            JSExpression lOperand = node.getLOperand();
            if (lOperand == null) {
                return;
            }
            lOperand.accept((PsiElementVisitor)this);
            Object leftValue = this.getResult();
            if (leftValue == null) {
                return;
            }
            JSExpression rOperand = node.getROperand();
            if (rOperand == null) {
                return;
            }
            rOperand.accept((PsiElementVisitor)this);
            Object rightValue = this.getResult();
            if (rightValue == null) {
                return;
            }
            Object value = null;
            IElementType operationSign = node.getOperationSign();
            if (operationSign == JSTokenTypes.EQEQEQ || operationSign == JSTokenTypes.NEQEQ) {
                boolean eq = leftValue.equals(rightValue);
                value = operationSign == JSTokenTypes.EQEQEQ ? eq : !eq;
            }
            if (operationSign == JSTokenTypes.EQEQ) {
                value = JSComputeConstantExpressionVisitor.computeEquality(leftValue, rightValue);
            } else if (operationSign == JSTokenTypes.NE) {
                value = !JSComputeConstantExpressionVisitor.computeEquality(leftValue, rightValue);
            } else if (operationSign == JSTokenTypes.ANDAND) {
                Boolean leftBoolean = JSComputeConstantExpressionVisitor.toBoolean(leftValue);
                value = leftBoolean == false ? leftValue : rightValue;
            } else if (operationSign == JSTokenTypes.OROR) {
                Boolean leftBoolean = JSComputeConstantExpressionVisitor.toBoolean(leftValue);
                value = leftBoolean != false ? leftValue : rightValue;
            } else if (operationSign == JSTokenTypes.PLUS && (leftValue instanceof String || rightValue instanceof String)) {
                value = leftValue.toString() + rightValue.toString();
            } else {
                Number leftNumber = JSComputeConstantExpressionVisitor.toNumber(leftValue);
                Number rightNumber = JSComputeConstantExpressionVisitor.toNumber(rightValue);
                if (operationSign == JSTokenTypes.PLUS) {
                    value = leftNumber.doubleValue() + rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MINUS) {
                    value = leftNumber.doubleValue() - rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.MULT) {
                    value = leftNumber.doubleValue() * rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.DIV) {
                    value = leftNumber.doubleValue() / rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.PERC) {
                    value = leftNumber.doubleValue() % rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.LTLT) {
                    value = leftNumber.longValue() << (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.GTGT) {
                    value = leftNumber.longValue() >> (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.GTGTGT) {
                    value = leftNumber.longValue() >>> (int)rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.EQEQ) {
                    value = leftNumber.equals(rightNumber);
                } else if (operationSign == JSTokenTypes.NE) {
                    value = !leftNumber.equals(rightNumber);
                } else if (operationSign == JSTokenTypes.LT) {
                    value = leftNumber.doubleValue() < rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.GT) {
                    value = leftNumber.doubleValue() > rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.LE) {
                    value = leftNumber.doubleValue() <= rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.GE) {
                    value = leftNumber.doubleValue() >= rightNumber.doubleValue();
                } else if (operationSign == JSTokenTypes.AND) {
                    value = leftNumber.longValue() & rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.OR) {
                    value = leftNumber.longValue() | rightNumber.longValue();
                } else if (operationSign == JSTokenTypes.XOR) {
                    value = leftNumber.longValue() ^ rightNumber.longValue();
                }
            }
            this.pushValue(value);
        }

        @NotNull
        private static Number toNumber(Object value) {
            Number number = value instanceof String ? (Number)JSComputeConstantExpressionVisitor.getNumericValue((String)value) : (Number)(value instanceof Boolean ? (Number)((Boolean)value != false ? 1L : 0L) : (Number)((Number)value));
            Number number2 = number;
            if (number2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/psiutil/ExpressionUtil$JSComputeConstantExpressionVisitor", "toNumber"));
            }
            return number2;
        }

        @NotNull
        private static Number getNumericValue(String text) {
            Number value;
            try {
                value = !(!text.startsWith("0x") && !text.startsWith("0X") || text.contains(".") || text.contains("e") || text.contains("E")) ? (Number)Long.parseLong(text.substring(2), 16) : (Number)Double.parseDouble(text);
            }
            catch (NumberFormatException e) {
                value = Double.NaN;
            }
            Double d = value;
            if (d == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/psiutil/ExpressionUtil$JSComputeConstantExpressionVisitor", "getNumericValue"));
            }
            return d;
        }

        @NotNull
        private static Boolean toBoolean(Object value) {
            double doubleValue;
            Boolean v = value instanceof String ? Boolean.valueOf(((String)value).length() > 0) : (value instanceof Number ? Boolean.valueOf((doubleValue = ((Number)value).doubleValue()) != 0.0 && !Double.isNaN(doubleValue)) : (Boolean)value);
            Boolean bl = v;
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/psiutil/ExpressionUtil$JSComputeConstantExpressionVisitor", "toBoolean"));
            }
            return bl;
        }

        private static boolean computeEquality(Object leftValue, Object rightValue) {
            if (leftValue instanceof Number && rightValue instanceof Number) {
                return ((Number)leftValue).doubleValue() == ((Number)rightValue).doubleValue();
            }
            if (leftValue.getClass() == rightValue.getClass()) {
                return leftValue.equals(rightValue);
            }
            if (leftValue instanceof Number && rightValue instanceof String) {
                return JSComputeConstantExpressionVisitor.computeEquality(leftValue, JSComputeConstantExpressionVisitor.toNumber(rightValue));
            }
            if (leftValue instanceof String && rightValue instanceof Number) {
                return JSComputeConstantExpressionVisitor.computeEquality(JSComputeConstantExpressionVisitor.toNumber(leftValue), rightValue);
            }
            if (leftValue instanceof Boolean) {
                return JSComputeConstantExpressionVisitor.computeEquality(JSComputeConstantExpressionVisitor.toNumber(leftValue), rightValue);
            }
            if (rightValue instanceof Boolean) {
                return JSComputeConstantExpressionVisitor.computeEquality(leftValue, JSComputeConstantExpressionVisitor.toNumber(rightValue));
            }
            return false;
        }

        @Nullable
        private static Number computeIncrementDecrementExpression(@NotNull Number value, IElementType operationSign) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/intellij/idea/lang/javascript/psiutil/ExpressionUtil$JSComputeConstantExpressionVisitor", "computeIncrementDecrementExpression"));
            }
            Long v = null;
            if (operationSign == JSTokenTypes.PLUSPLUS) {
                v = value.longValue() + 1L;
            } else if (operationSign == JSTokenTypes.MINUSMINUS) {
                v = value.longValue() - 1L;
            }
            return v;
        }
    }

    public static class IsConstantExpressionVisitor
    extends JSElementVisitor {
        protected boolean isConstant;
        private final Map<JSVariable, Boolean> isVariableConstant = new HashMap<JSVariable, Boolean>();
        private static final int MAX_WALK_DEPTH = JavaScriptParserBase.MAX_TREE_DEPTH;
        private int myWalkDepth = 0;

        public boolean isConstant() {
            return this.isConstant;
        }

        public void visitJSExpression(JSExpression expression) {
            this.isConstant = false;
        }

        public void visitJSStringTemplateExpression(JSStringTemplateExpression stringTemplateExpression) {
            this.isConstant = stringTemplateExpression.getArguments().length == 0;
        }

        public void visitJSLiteralExpression(JSLiteralExpression expression) {
            this.isConstant = true;
        }

        public void visitJSParenthesizedExpression(JSParenthesizedExpression expression) {
            JSExpression expr = expression.getInnerExpression();
            if (expr != null) {
                expr.accept((PsiElementVisitor)this);
            }
        }

        public void visitJSPrefixExpression(JSPrefixExpression expression) {
            this.visitJSPrefixOrPostfixExpression(expression.getExpression(), expression.getOperationSign());
        }

        public void visitJSPostfixExpression(JSPostfixExpression expression) {
            this.visitJSPrefixOrPostfixExpression(expression.getExpression(), expression.getOperationSign());
        }

        public void visitJSPrefixOrPostfixExpression(JSExpression operand, IElementType sign) {
            if (operand == null) {
                this.isConstant = false;
                return;
            }
            operand.accept((PsiElementVisitor)this);
            if (!this.isConstant) {
                return;
            }
            if (sign == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.TILDE || sign == JSTokenTypes.EXCL) {
                return;
            }
            this.isConstant = false;
        }

        public void visitJSBinaryExpression(JSBinaryExpression expression) {
            if (this.myWalkDepth > MAX_WALK_DEPTH) {
                this.isConstant = false;
                return;
            }
            ++this.myWalkDepth;
            JSExpression jsExpression = expression.getLOperand();
            if (jsExpression == null) {
                return;
            }
            jsExpression.accept((PsiElementVisitor)this);
            if (!this.isConstant) {
                return;
            }
            JSExpression rOperand = expression.getROperand();
            if (rOperand != null) {
                rOperand.accept((PsiElementVisitor)this);
            }
            --this.myWalkDepth;
        }

        public void visitJSConditionalExpression(JSConditionalExpression expression) {
            JSExpression thenExpr = expression.getThen();
            JSExpression elseExpr = expression.getElse();
            if (thenExpr == null || elseExpr == null) {
                this.isConstant = false;
                return;
            }
            JSExpression condition = expression.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
            }
            if (!this.isConstant) {
                return;
            }
            thenExpr.accept((PsiElementVisitor)this);
            if (!this.isConstant) {
                return;
            }
            elseExpr.accept((PsiElementVisitor)this);
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            PsiElement resolve = expression.resolve();
            if (!(resolve instanceof JSElement)) {
                return;
            }
            JSElement refElement = (JSElement)resolve;
            if (!(refElement instanceof JSVariable)) {
                this.isConstant = false;
                return;
            }
            JSVariable variable = (JSVariable)refElement;
            Boolean isConst = this.isVariableConstant.get(variable);
            if (isConst != null) {
                this.isConstant &= isConst.booleanValue();
                return;
            }
            this.isVariableConstant.put(variable, Boolean.FALSE);
            this.isConstant = false;
        }
    }
}

