/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;

public class NumberUtil {
    private static final BigInteger VALUE_ZERO = new BigInteger(new byte[]{0});

    private NumberUtil() {
    }

    public static BigInteger getLiteralNumber(JSLiteralExpression expression) {
        Object value = expression.getValue();
        if (!(value instanceof Long)) {
            return VALUE_ZERO;
        }
        return BigInteger.valueOf((Long)value);
    }

    public static boolean isInteger(JSLiteralExpression expression) {
        return expression.isNumericLiteral() && (expression.isHexLiteral() || expression.isBinaryLiteral() || expression.isOctalLiteral() || !StringUtil.containsAnyChar((String)expression.getText(), (String)".eE"));
    }
}

