/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;

public class ParenthesesUtils {
    private static final int PARENTHESIZED_PRECENDENCE = 0;
    private static final int LITERAL_PRECENDENCE = 0;
    public static final int METHOD_CALL_PRECENDENCE = 1;
    private static final int POSTFIX_PRECENDENCE = 2;
    public static final int PREFIX_PRECENDENCE = 3;
    public static final int TYPE_CAST_PRECENDENCE = 4;
    public static final int MULTIPLICATIVE_PRECENDENCE = 5;
    private static final int ADDITIVE_PRECENDENCE = 6;
    public static final int SHIFT_PRECENDENCE = 7;
    private static final int RELATIONAL_PRECENDENCE = 8;
    public static final int EQUALITY_PRECENDENCE = 9;
    private static final int BINARY_AND_PRECENDENCE = 10;
    private static final int BINARY_XOR_PRECENDENCE = 11;
    private static final int BINARY_OR_PRECENDENCE = 12;
    public static final int AND_PRECENDENCE = 13;
    public static final int OR_PRECENDENCE = 14;
    public static final int CONDITIONAL_PRECENDENCE = 15;
    private static final int ASSIGNMENT_PRECENDENCE = 16;
    private static final int NUM_PRECENDENCES = 17;
    private static final Map<IElementType, Integer> binaryOperatorPrecendence = new HashMap<IElementType, Integer>(17);

    private ParenthesesUtils() {
    }

    public static JSExpression stripParentheses(JSExpression expression) {
        JSExpression parenthesized = expression;
        if (parenthesized != null) {
            while (parenthesized instanceof JSParenthesizedExpression) {
                parenthesized = ((JSParenthesizedExpression)parenthesized).getInnerExpression();
            }
        }
        return parenthesized;
    }

    public static JSExpression unstripParentheses(JSExpression expression) {
        JSExpression parenthesized = expression;
        if (parenthesized != null) {
            PsiElement parent = parenthesized.getParent();
            while (parent instanceof JSParenthesizedExpression) {
                parenthesized = (JSParenthesizedExpression)parent;
                parent = parenthesized.getParent();
            }
        }
        return parenthesized;
    }

    public static String getParenthesized(JSExpression expression, int precendence) {
        return ParenthesesUtils.getPrecendence(expression) > precendence ? '(' + expression.getText() + ')' : expression.getText();
    }

    public static int getPrecendence(JSExpression expression) {
        if (expression instanceof JSThisExpression || expression instanceof JSLiteralExpression || expression instanceof JSArrayLiteralExpression || expression instanceof JSObjectLiteralExpression || expression instanceof JSIndexedPropertyAccessExpression) {
            return 0;
        }
        if (expression instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)expression).getQualifier() == null ? 0 : 1;
        }
        if (expression instanceof JSNewExpression) {
            return 4;
        }
        if (expression instanceof JSCallExpression) {
            return 1;
        }
        if (expression instanceof JSPostfixExpression) {
            return 2;
        }
        if (expression instanceof JSPrefixExpression) {
            return 3;
        }
        if (expression instanceof JSAssignmentExpression) {
            return 16;
        }
        if (expression instanceof JSBinaryExpression) {
            return ParenthesesUtils.getBinaryOperatorPrecendence(((JSBinaryExpression)expression).getOperationSign());
        }
        if (expression instanceof JSConditionalExpression) {
            return 15;
        }
        if (expression instanceof JSParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    private static int getBinaryOperatorPrecendence(IElementType sign) {
        if (binaryOperatorPrecendence.containsKey(sign)) {
            return binaryOperatorPrecendence.get(sign);
        }
        return 16;
    }

    public static String removeParentheses(JSExpression expression) {
        if (expression instanceof JSCallExpression) {
            return ParenthesesUtils.removeParensFromFunctionCallExpression((JSCallExpression)expression);
        }
        if (expression instanceof JSReferenceExpression) {
            return ParenthesesUtils.removeParensFromReferenceExpression((JSReferenceExpression)expression);
        }
        if (expression instanceof JSAssignmentExpression) {
            return ParenthesesUtils.removeParensFromAssignmentExpression((JSAssignmentExpression)expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return ParenthesesUtils.removeParensFromArrayLiteralExpression((JSArrayLiteralExpression)expression);
        }
        if (expression instanceof JSPrefixExpression) {
            return ParenthesesUtils.removeParensFromPrefixExpression((JSPrefixExpression)expression);
        }
        if (expression instanceof JSPostfixExpression) {
            return ParenthesesUtils.removeParensFromPostfixExpression((JSPostfixExpression)expression);
        }
        if (expression instanceof JSBinaryExpression) {
            return ParenthesesUtils.removeParensFromBinaryExpression((JSBinaryExpression)expression);
        }
        if (expression instanceof JSConditionalExpression) {
            return ParenthesesUtils.removeParensFromConditionalExpression((JSConditionalExpression)expression);
        }
        if (expression instanceof JSParenthesizedExpression) {
            JSExpression innerExpression = ((JSParenthesizedExpression)expression).getInnerExpression();
            if (innerExpression instanceof JSCallExpression) {
                return innerExpression.getText();
            }
            return ParenthesesUtils.removeParensFromParenthesizedExpression((JSParenthesizedExpression)expression);
        }
        return expression.getText();
    }

    private static String removeParensFromReferenceExpression(JSReferenceExpression expression) {
        JSExpression qualifier = expression.getQualifier();
        if (qualifier != null) {
            return ParenthesesUtils.removeParentheses(qualifier) + '.' + expression.getReferencedName();
        }
        return expression.getText();
    }

    private static String removeParensFromParenthesizedExpression(JSParenthesizedExpression parenthesizedExp) {
        int childPrecendence;
        JSExpression body = ParenthesesUtils.stripParentheses(parenthesizedExp.getInnerExpression());
        if (!(parenthesizedExp.getParent() instanceof JSExpression)) {
            return ParenthesesUtils.removeParentheses(body);
        }
        JSExpression parentExp = (JSExpression)parenthesizedExp.getParent();
        int parentPrecendence = ParenthesesUtils.getPrecendence(parentExp);
        if (parentPrecendence < (childPrecendence = ParenthesesUtils.getPrecendence(body))) {
            return '(' + ParenthesesUtils.removeParentheses(body) + ')';
        }
        if (parentPrecendence == childPrecendence) {
            if (parentExp instanceof JSBinaryExpression && body instanceof JSBinaryExpression) {
                IElementType parentOperator = ((JSBinaryExpression)parentExp).getOperationSign();
                IElementType bodyOperator = ((JSBinaryExpression)body).getOperationSign();
                JSExpression lhs = ((JSBinaryExpression)parentExp).getLOperand();
                if (lhs.equals(parenthesizedExp) && parentOperator.equals(bodyOperator)) {
                    return ParenthesesUtils.removeParentheses(body);
                }
                return '(' + ParenthesesUtils.removeParentheses(body) + ')';
            }
            return ParenthesesUtils.removeParentheses(body);
        }
        return ParenthesesUtils.removeParentheses(body);
    }

    private static String removeParensFromConditionalExpression(JSConditionalExpression conditionalExp) {
        JSExpression condition = conditionalExp.getCondition();
        JSExpression thenBranch = conditionalExp.getThen();
        JSExpression elseBranch = conditionalExp.getElse();
        return ParenthesesUtils.removeParentheses(condition) + " ? " + ParenthesesUtils.removeParentheses(thenBranch) + " : " + ParenthesesUtils.removeParentheses(elseBranch);
    }

    private static String removeParensFromBinaryExpression(JSBinaryExpression binaryExp) {
        JSExpression lhs = binaryExp.getLOperand();
        JSExpression rhs = binaryExp.getROperand();
        IElementType sign = binaryExp.getOperationSign();
        return ParenthesesUtils.removeParentheses(lhs) + ' ' + BinaryOperatorUtils.getOperatorText(sign) + ' ' + ParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromPostfixExpression(JSPostfixExpression postfixExp) {
        JSExpression body = postfixExp.getExpression();
        IElementType sign = postfixExp.getOperationSign();
        return ParenthesesUtils.removeParentheses(body) + BinaryOperatorUtils.getOperatorText(sign);
    }

    private static String removeParensFromPrefixExpression(JSPrefixExpression prefixExp) {
        JSExpression body = prefixExp.getExpression();
        IElementType sign = prefixExp.getOperationSign();
        String bodyText = ParenthesesUtils.removeParentheses(body);
        assert (sign != null) : prefixExp.getText();
        String signText = BinaryOperatorUtils.getOperatorText(sign);
        if (sign == JSTokenTypes.TYPEOF_KEYWORD || sign == JSTokenTypes.DELETE_KEYWORD) {
            signText = signText + " ";
        }
        return signText + bodyText;
    }

    private static String removeParensFromArrayLiteralExpression(JSArrayLiteralExpression init) {
        JSExpression[] contents = init.getExpressions();
        String text = init.getText();
        int textLength = text.length();
        StringBuilder out = new StringBuilder(textLength);
        out.append('[');
        ParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(contents, out);
        return out.append(']').toString();
    }

    private static void removeParenthesesFromCommaSeparatedExpressions(JSExpression[] contents, StringBuilder out) {
        for (int index = 0; index < contents.length; ++index) {
            JSExpression arg = contents[index];
            if (index != 0) {
                out.append(',');
            }
            out.append(ParenthesesUtils.removeParentheses(arg));
        }
    }

    private static String removeParensFromAssignmentExpression(JSAssignmentExpression assignment) {
        JSExpression lhs = assignment.getLOperand();
        JSExpression rhs = assignment.getROperand();
        IElementType sign = assignment.getOperationSign();
        return ParenthesesUtils.removeParentheses(lhs) + ' ' + BinaryOperatorUtils.getOperatorText(sign) + ' ' + ParenthesesUtils.removeParentheses(rhs);
    }

    private static String removeParensFromFunctionCallExpression(JSCallExpression functionCall) {
        JSExpression target = functionCall.getMethodExpression();
        JSExpression[] args = functionCall.getArguments();
        String methodCallText = functionCall.getText();
        int length = methodCallText.length();
        StringBuilder out = new StringBuilder(length);
        String strippedTarget = ParenthesesUtils.removeParentheses(target);
        out.append(strippedTarget);
        out.append('(');
        ParenthesesUtils.removeParenthesesFromCommaSeparatedExpressions(args, out);
        out.append(')');
        return out.toString();
    }

    static {
        binaryOperatorPrecendence.put(JSTokenTypes.PLUS, 6);
        binaryOperatorPrecendence.put(JSTokenTypes.MINUS, 6);
        binaryOperatorPrecendence.put(JSTokenTypes.MULT, 5);
        binaryOperatorPrecendence.put(JSTokenTypes.DIV, 5);
        binaryOperatorPrecendence.put(JSTokenTypes.PERC, 5);
        binaryOperatorPrecendence.put(JSTokenTypes.ANDAND, 13);
        binaryOperatorPrecendence.put(JSTokenTypes.OROR, 14);
        binaryOperatorPrecendence.put(JSTokenTypes.AND, 10);
        binaryOperatorPrecendence.put(JSTokenTypes.OR, 12);
        binaryOperatorPrecendence.put(JSTokenTypes.XOR, 11);
        binaryOperatorPrecendence.put(JSTokenTypes.COMMA, 16);
        binaryOperatorPrecendence.put(JSTokenTypes.LTLT, 7);
        binaryOperatorPrecendence.put(JSTokenTypes.GTGT, 7);
        binaryOperatorPrecendence.put(JSTokenTypes.GTGTGT, 7);
        binaryOperatorPrecendence.put(JSTokenTypes.GT, 8);
        binaryOperatorPrecendence.put(JSTokenTypes.GE, 8);
        binaryOperatorPrecendence.put(JSTokenTypes.LT, 8);
        binaryOperatorPrecendence.put(JSTokenTypes.LE, 8);
        binaryOperatorPrecendence.put(JSTokenTypes.EQEQ, 9);
        binaryOperatorPrecendence.put(JSTokenTypes.NE, 9);
        binaryOperatorPrecendence.put(JSTokenTypes.EQEQEQ, 9);
        binaryOperatorPrecendence.put(JSTokenTypes.NEQEQ, 9);
    }
}

