/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;

public class LessLangUtil {
    private LessLangUtil() {
    }

    public static boolean isVisibleDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement reference) {
        CssRuleset rulesetParent;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/plugins/less/LessLangUtil", "isVisibleDeclaration"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/plugins/less/LessLangUtil", "isVisibleDeclaration"));
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)reference, CssSelectorList.class, (boolean)false) != null && (rulesetParent = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)reference, CssRuleset.class)) != null) {
            reference = rulesetParent;
        }
        PsiElement declarationScope = LessLangUtil.getOriginalScope(declaration);
        PsiElement originalScope = LessLangUtil.getOriginalScope(reference);
        return declarationScope instanceof PsiFile || originalScope != null && PsiTreeUtil.isAncestor((PsiElement)declarationScope, (PsiElement)originalScope, (boolean)false);
    }

    @Nullable
    public static PsiElement getOriginalScope(PsiElement reference) {
        PsiElement myElementScope = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiFile.class, CssRuleset.class, LESSMixin.class, LESSMixinInvocation.class});
        PsiElement originalScope = myElementScope != null ? CompletionUtil.getOriginalElement((PsiElement)myElementScope) : null;
        return originalScope == null && myElementScope != null ? LessLangUtil.getOriginalScope(myElementScope) : originalScope;
    }

    @Nullable
    public static ResolveResult filterOverridedResults(Collection<ResolveResult> result, PsiElement reference) {
        ResolveResult singleResult = null;
        PsiFile originalFile = reference.getContainingFile();
        for (ResolveResult resolveResult : result) {
            PsiElement resolvedResultScope;
            PsiElement resolvedElement = resolveResult.getElement();
            if (resolvedElement == null || originalFile != resolvedElement.getContainingFile()) continue;
            if (singleResult == null) {
                singleResult = resolveResult;
                continue;
            }
            PsiElement singleResultElement = singleResult.getElement();
            if (singleResultElement == null) continue;
            PsiElement singleResultScope = LessLangUtil.getOriginalScope(singleResultElement);
            if (singleResultScope == (resolvedResultScope = LessLangUtil.getOriginalScope(resolvedElement))) {
                if (resolvedElement.getTextOffset() <= singleResultElement.getTextOffset()) continue;
                singleResult = resolveResult;
                continue;
            }
            if (resolvedResultScope == null || !PsiTreeUtil.isAncestor((PsiElement)singleResultScope, (PsiElement)resolvedResultScope, (boolean)false)) continue;
            singleResult = resolveResult;
        }
        return singleResult;
    }
}

