/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.impl.LessImportType;

public class LessImportTypeCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> OUR_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            Project project = context.getProject();
            if (LessImportTypeCompletionProvider.moveCaretOnChar(editor, ',')) {
                LessImportTypeCompletionProvider.typeCharOrMoveCaret(editor, project, ' ');
            }
        }
    };

    private static void typeCharOrMoveCaret(@NotNull Editor editor, @NotNull Project project, char c) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider", "typeCharOrMoveCaret"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider", "typeCharOrMoveCaret"));
        }
        if (!LessImportTypeCompletionProvider.isCharAtCaret(editor, c)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(c));
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        } else {
            editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
        }
    }

    private static boolean moveCaretOnChar(@NotNull Editor editor, char c) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider", "moveCaretOnChar"));
        }
        if (LessImportTypeCompletionProvider.isCharAtCaret(editor, c)) {
            editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            return true;
        }
        return false;
    }

    private static boolean isCharAtCaret(@NotNull Editor editor, char c) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider", "isCharAtCaret"));
        }
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == c;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/provider/LessImportTypeCompletionProvider", "addCompletions"));
        }
        for (String importType : LessImportType.KNOWN_IMPORT_TYPES) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)importType).withInsertHandler(OUR_INSERT_HANDLER));
        }
    }
}

