/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LessNamespaceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final boolean myInPureNamespaceInvocation;

    public LessNamespaceCompletionProvider(boolean inPureNamespaceInvocation) {
        this.myInPureNamespaceInvocation = inPureNamespaceInvocation;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/provider/LessNamespaceCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/provider/LessNamespaceCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        if (this.myInPureNamespaceInvocation) {
            LESSNamespace namespace = (LESSNamespace)PsiTreeUtil.getParentOfType((PsiElement)position, LESSNamespace.class);
            String namespaceString = namespace != null ? namespace.getNamespace() : "";
            String prefix = namespace != null ? namespace.getPrefix() : "";
            LessNamespaceCompletionProvider.addCompletions(result, position, project, (PsiElement)namespace, namespaceString, prefix, parameters.getOriginalFile());
        } else {
            CssSelectorList cssSelectorList = (CssSelectorList)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorList.class);
            CssSelectorSuffix cssSelectorSuffix = (CssSelectorSuffix)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorSuffix.class);
            if (cssSelectorList != null && cssSelectorSuffix != null) {
                PsiElement simpleSelector = PsiTreeUtil.getParentOfType((PsiElement)cssSelectorSuffix, CssSimpleSelector.class);
                if (simpleSelector == null || !simpleSelector.getText().equals(cssSelectorSuffix.getText())) {
                    return;
                }
                CssSelector[] selectors = cssSelectorList.getSelectors();
                if (selectors.length == 1) {
                    CssSelector cssSelector = selectors[0];
                    String namespaceString = LESSUtil.getNamespaceForSelector(cssSelector, cssSelectorSuffix);
                    String prefix = LESSUtil.getSelectorPrefix(cssSelectorSuffix);
                    LessNamespaceCompletionProvider.addCompletions(result, position, project, (PsiElement)cssSelectorSuffix, namespaceString, prefix, parameters.getOriginalFile());
                }
            }
        }
    }

    private static void addCompletions(CompletionResultSet result, PsiElement position, Project project, @Nullable PsiElement mixinInvocation, String invocationNamespace, String prefix, PsiFile file) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)file, (PsiElement)position, (boolean)false);
        for (String name : StubIndex.getInstance().getAllKeys(LessMixinIndex.KEY, project)) {
            if (name.isEmpty() || !name.startsWith(prefix)) continue;
            LessMixinIndex.process(name, project, scope, (Processor<? super LESSMixin>)((Processor)mixin -> {
                if (!mixin.hasParameters() && LESSUtil.isMixinMatchesWithInvocation(mixin, mixinInvocation, invocationNamespace)) {
                    boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                    result.addElement(LESSUtil.createMixinLookupItem(mixin, validResult));
                }
                return true;
            }));
        }
    }
}

