/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.stubs.types;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;
import org.jetbrains.plugins.less.psi.stubs.impl.LessMixinStub;

public abstract class LessMixinStubElementType
extends CssNamedStubElementType<LessMixinStub, LESSMixin> {
    protected LessMixinStubElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "<init>"));
        }
        super(debugName, (Language)LESSLanguage.INSTANCE);
    }

    public void indexStub(@NotNull LessMixinStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "indexStub"));
        }
        sink.occurrence(LessMixinIndex.KEY, (Object)StringUtil.notNullize((String)stub.getFullName()));
    }

    @NotNull
    public LessMixinStub createStub(@NotNull LESSMixin psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "createStub"));
        }
        LessMixinStub lessMixinStub = new LessMixinStub(parentStub, (IStubElementType)this, psi.getName(), psi.getTextOffset(), psi.getFullName(), psi.getNamespace());
        if (lessMixinStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "createStub"));
        }
        return lessMixinStub;
    }

    public void serialize(@NotNull LessMixinStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "serialize"));
        }
        this.serializeNameAndTextOffset(stub, dataStream);
        dataStream.writeUTFFast(stub.getFullName());
        dataStream.writeUTFFast(stub.getNamespace());
    }

    @NotNull
    public LessMixinStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "deserialize"));
        }
        Pair nameAndTextOffset = this.deserializeNameAndTextOffset(dataStream);
        String fullName = dataStream.readUTFFast();
        String namespace = dataStream.readUTFFast();
        LessMixinStub lessMixinStub = new LessMixinStub(parentStub, (IStubElementType)this, (StringRef)nameAndTextOffset.first, (int)((Integer)nameAndTextOffset.second), fullName, namespace);
        if (lessMixinStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/stubs/types/LessMixinStubElementType", "deserialize"));
        }
        return lessMixinStub;
    }
}

