/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.ArrayMapping;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLabelImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class DockerAgentContainerConfigImpl
implements DockerAgentContainerConfig {
    private final String[] myCommand;
    private final String[] myEntrypoint;
    private final Boolean myPublishAllPorts;
    private final DockerPortBinding[] myPortBindings;
    private final Integer[] myExposedPorts;
    private final DockerLink[] myLinks;
    private final DockerVolumeBinding[] myVolumeBindings;
    private final DockerEnvVar[] myEnvVars;
    private final String myWorkingDir;
    private final DockerVolumesFrom[] myVolumesFrom;
    private final Boolean myNetworkDisabled;
    private final String myNetworkMode;
    private final String[] myExtraHosts;
    private final String myContainerName;
    private final String myUser;
    private final DockerLabel[] myLabels;

    public static DockerAgentContainerConfigImpl createEmptyConfig() {
        return new DockerAgentContainerConfigImpl((CreateContainerCmd)new CreateContainerCmdConfig(){

            public Boolean getPublishAllPorts() {
                return null;
            }
        });
    }

    public DockerAgentContainerConfigImpl(DockerAgentContainerConfig source) {
        this.myCommand = source.getCommand();
        this.myEntrypoint = source.getEntrypoint();
        this.myPortBindings = source.getPortBindings();
        this.myPublishAllPorts = source.getPublishAllPorts();
        this.myExposedPorts = source.getExposedPorts();
        this.myLinks = source.getLinks();
        this.myVolumeBindings = source.getVolumeBindings();
        this.myEnvVars = source.getEnvVars();
        this.myWorkingDir = source.getWorkingDir();
        this.myVolumesFrom = source.getVolumesFrom();
        this.myNetworkDisabled = source.getNetworkDisabled();
        this.myNetworkMode = source.getNetworkMode();
        this.myExtraHosts = source.getExtraHosts();
        this.myContainerName = source.getContainerName();
        this.myUser = source.getUser();
        this.myLabels = source.getLabels();
    }

    public DockerAgentContainerConfigImpl(CreateContainerCmd cmd) {
        this.myCommand = cmd.getCmd();
        this.myEntrypoint = cmd.getEntrypoint();
        this.myPublishAllPorts = cmd.getPublishAllPorts();
        this.myPortBindings = DockerAgentContainerConfigImpl.createAgentPortBindings(cmd.getPortBindings());
        this.myExposedPorts = DockerAgentContainerConfigImpl.createAgentExposedPorts(cmd.getExposedPorts());
        this.myLinks = DockerAgentContainerConfigImpl.createAgentLinks(cmd.getLinks());
        this.myVolumeBindings = DockerAgentContainerConfigImpl.createAgentVolumeBindings(cmd.getBinds(), cmd.getVolumes());
        this.myEnvVars = DockerAgentContainerConfigImpl.createAgentEnvVars(cmd.getEnv());
        this.myWorkingDir = cmd.getWorkingDir();
        this.myVolumesFrom = DockerAgentContainerConfigImpl.createAgentVolumesFrom(cmd.getVolumesFrom());
        this.myNetworkDisabled = cmd.isNetworkDisabled();
        this.myNetworkMode = cmd.getNetworkMode();
        this.myExtraHosts = cmd.getExtraHosts();
        this.myContainerName = cmd.getName();
        this.myUser = cmd.getUser();
        this.myLabels = DockerAgentContainerConfigImpl.createAgentLabels(cmd.getLabels());
    }

    public String[] getEntrypoint() {
        return this.myEntrypoint;
    }

    public String[] getCommand() {
        return this.myCommand;
    }

    public String getContainerName() {
        return this.myContainerName;
    }

    public String getUser() {
        return this.myUser;
    }

    public DockerLabel[] getLabels() {
        return this.myLabels;
    }

    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public String[] getExtraHosts() {
        return this.myExtraHosts;
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public Boolean getNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public Boolean getPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public boolean isPublishAllPorts() {
        return Boolean.TRUE.equals(this.getPublishAllPorts());
    }

    public DockerPortBinding[] getPortBindings() {
        return this.myPortBindings;
    }

    public Integer[] getExposedPorts() {
        return this.myExposedPorts;
    }

    public DockerLink[] getLinks() {
        return this.myLinks;
    }

    public DockerVolumeBinding[] getVolumeBindings() {
        return this.myVolumeBindings;
    }

    public DockerEnvVar[] getEnvVars() {
        return this.myEnvVars;
    }

    public Ports createCmdPortBindings() {
        if (this.isPublishAllPorts() || this.myPortBindings == null) {
            return null;
        }
        return new Ports((PortBinding[])new ArrayMapping<DockerPortBinding, PortBinding>(){

            protected PortBinding mapElement(DockerPortBinding source) {
                return new PortBinding(new Ports.Binding(source.getHostIp(), source.getHostPort() != null ? String.valueOf(source.getHostPort()) : null), new ExposedPort(source.getContainerPort(), InternetProtocol.parse((String)source.getProtocol())));
            }
        }.map((Object[])this.myPortBindings, PortBinding.class));
    }

    private static DockerPortBinding[] createAgentPortBindings(Ports ports) {
        if (ports == null) {
            return null;
        }
        ArrayList<DockerPortBindingImpl> portBindings = new ArrayList<DockerPortBindingImpl>();
        for (Map.Entry portEntry : ports.getBindings().entrySet()) {
            ExposedPort exposedPort = (ExposedPort)portEntry.getKey();
            for (Ports.Binding binding : (Ports.Binding[])portEntry.getValue()) {
                DockerPortBindingImpl portBinding = new DockerPortBindingImpl();
                portBinding.setHostIp(binding.getHostIp());
                portBinding.setHostPort(DockerAgentContainerConfigImpl.isEmptyOrNull(binding.getHostPortSpec()) ? null : Integer.valueOf(Integer.parseInt(binding.getHostPortSpec())));
                portBinding.setProtocol(exposedPort.getProtocol().toString());
                portBinding.setContainerPort(exposedPort.getPort());
                portBindings.add(portBinding);
            }
        }
        return portBindings.toArray(new DockerPortBinding[portBindings.size()]);
    }

    public ExposedPort[] createCmdExposedPorts() {
        return (ExposedPort[])new ArrayMapping<Integer, ExposedPort>(){

            protected ExposedPort mapElement(Integer source) {
                return new ExposedPort(source.intValue());
            }
        }.map((Object[])this.myExposedPorts, ExposedPort.class);
    }

    private static Integer[] createAgentExposedPorts(ExposedPort[] ports) {
        return (Integer[])new ArrayMapping<ExposedPort, Integer>(){

            protected Integer mapElement(ExposedPort source) {
                return source.getPort();
            }
        }.map((Object[])ports, Integer.class);
    }

    public Link[] createCmdLinks() {
        return (Link[])new ArrayMapping<DockerLink, Link>(){

            protected Link mapElement(DockerLink source) {
                String name = source.getName();
                String alias = source.getAlias();
                return new Link(name, alias == null ? name : alias);
            }
        }.map((Object[])this.myLinks, Link.class);
    }

    private static DockerLink[] createAgentLinks(Link[] links) {
        return (DockerLink[])new ArrayMapping<Link, DockerLink>(){

            protected DockerLink mapElement(Link source) {
                DockerLinkImpl result = new DockerLinkImpl();
                result.setName(source.getName());
                result.setAlias(source.getAlias());
                return result;
            }
        }.map((Object[])links, DockerLink.class);
    }

    public VolumesFrom[] createCmdVolumesFrom() {
        return (VolumesFrom[])new ArrayMapping<DockerVolumesFrom, VolumesFrom>(){

            protected VolumesFrom mapElement(DockerVolumesFrom source) {
                String sourceContainerId = source.getContainerId();
                return sourceContainerId == null ? null : new VolumesFrom(sourceContainerId, AccessMode.fromBoolean((boolean)source.isReadOnly()));
            }
        }.map((Object[])this.myVolumesFrom, VolumesFrom.class);
    }

    public Volume[] createCmdVolumes() {
        return (Volume[])new ArrayMapping<DockerVolumeBinding, Volume>(){

            protected Volume mapElement(DockerVolumeBinding source) {
                return source.getHostPath() == null ? new Volume(source.getContainerPath()) : null;
            }
        }.map((Object[])this.myVolumeBindings, Volume.class);
    }

    public Bind[] createCmdVolumeBindings() {
        return (Bind[])new ArrayMapping<DockerVolumeBinding, Bind>(){

            protected Bind mapElement(DockerVolumeBinding source) {
                String hostPath = source.getHostPath();
                return hostPath == null ? null : new Bind(hostPath, new Volume(source.getContainerPath()), AccessMode.fromBoolean((!source.isReadOnly() ? 1 : 0) != 0));
            }
        }.map((Object[])this.myVolumeBindings, Bind.class);
    }

    private static DockerVolumesFrom[] createAgentVolumesFrom(VolumesFrom[] volumesFroms) {
        return (DockerVolumesFrom[])new ArrayMapping<VolumesFrom, DockerVolumesFrom>(){

            protected DockerVolumesFrom mapElement(final VolumesFrom source) {
                return new DockerVolumesFrom(){

                    public String getContainerId() {
                        return source.getContainer();
                    }

                    public boolean isReadOnly() {
                        return source.getAccessMode().toBoolean();
                    }
                };
            }
        }.map((Object[])volumesFroms, DockerVolumesFrom.class);
    }

    private static DockerVolumeBinding[] createAgentVolumeBindings(Bind[] binds, Volume[] volumes) {
        if (binds.length == 0 && volumes.length == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(new ArrayMapping<Bind, DockerVolumeBinding>(){

            protected DockerVolumeBinding mapElement(Bind source) {
                DockerVolumeBindingImpl result = new DockerVolumeBindingImpl();
                String containerPath = source.getVolume().getPath();
                result.setContainerPath(containerPath);
                String hostPath = source.getPath();
                result.setHostPath(hostPath == null ? containerPath : hostPath);
                result.setReadOnly(!source.getAccessMode().toBoolean());
                return result;
            }
        }.map((Object[])binds, DockerVolumeBinding.class)));
        result.addAll(Arrays.asList(new ArrayMapping<Volume, DockerVolumeBinding>(){

            protected DockerVolumeBinding mapElement(Volume source) {
                DockerVolumeBindingImpl result = new DockerVolumeBindingImpl();
                result.setContainerPath(source.getPath());
                return result;
            }
        }.map((Object[])volumes, DockerVolumeBinding.class)));
        return result.toArray(new DockerVolumeBinding[result.size()]);
    }

    public String[] createCmdEnvVars() {
        return (String[])new ArrayMapping<DockerEnvVar, String>(){

            protected String mapElement(DockerEnvVar source) {
                return source.getName() + "=" + source.getValue();
            }
        }.map((Object[])this.myEnvVars, String.class);
    }

    private static DockerEnvVar[] createAgentEnvVars(String[] cmdEnv) {
        return (DockerEnvVar[])new ArrayMapping<String, DockerEnvVar>(){

            protected DockerEnvVar mapElement(String source) {
                DockerEnvVarImpl result = new DockerEnvVarImpl();
                String[] parts = source.split("=", 2);
                result.setName(parts[0]);
                result.setValue(parts.length == 1 ? "" : parts[1]);
                return result;
            }
        }.map((Object[])cmdEnv, DockerEnvVar.class);
    }

    private static DockerLabel[] createAgentLabels(Map<String, String> links) {
        return links == null ? null : (DockerLabel[])links.entrySet().stream().map(link -> {
            DockerLabelImpl result = new DockerLabelImpl();
            result.setKey((String)link.getKey());
            result.setValue((String)link.getValue());
            return result;
        }).toArray(DockerLabel[]::new);
    }

    private static boolean isEmptyOrNull(String text) {
        return text == null || text.isEmpty();
    }
}

